#region IMPORTS 
# from Library import * ob=Get_Active_Object() import bpy 
import bpy.types
import math as m
import time
import os
import random as r
import array
import mathutils
from mathutils import Vector, Matrix, Euler
import bmesh
import time
import collections
import contextlib
from math import pi
# For Cell-Fracture 
from addon_utils import enable
# For Printing 
from bpy import context
import builtins as __builtin__
#endregion 

########################################################################## 
Undo_VariableL1=list()
Undo_VariableR1=list()
BBN=1
########################################################################## 
########################################################################## 
#  Work with Pythion-LISTs 
########################################################################## 
########################################################################## 
# Remove first Listelement if equal to second 
def Py_Check_First(lst):
	num=len(lst)
	if num>1:
		if lst[0]==lst[1]:
			lst.pop(0)
			num=len(lst)
	return lst
########################################################################## 
########################################################################## 
#  Test if Oject was loaded as "Linked Object" 
# Does not work for "Linked Duplicates" 
# 
def Is_Obj_File_linked(ob):
	myo = bpy.data.objects[ob.name]
	re=myo.library
	print(re)
	if re == None:
		b = False
	else:
		b = True
	return b
########################################################################## 

def cprint(*args, **kwargs):
    """Print text to the Blender Python console."""
    # Find console area
    console_area = None
    for area in bpy.context.screen.areas:
        if area.type == 'CONSOLE':
            console_area = area
            break
    if not console_area:
        # Fallback to system console if no console area is found
        print("Warning: No CONSOLE area found. Printing to system console instead.")
        __builtin__.print(*args, **kwargs)
        return

    # Prepare text
    s = " ".join([str(arg) for arg in args])
    # Use temp_override for operator execution
    with bpy.context.temp_override(area=console_area, space_data=console_area.spaces.active, region=console_area.regions[-1]):
        for line in s.split("\n"):
            bpy.ops.console.scrollback_append(text=line)
########################################################################## 
########################################################################## 
def dprint(*args, **kwargs):
    """Print text to both Blender Python console and system console."""
    cprint(*args, **kwargs)  # to Blender console
    __builtin__.print(*args, **kwargs)  # to system console
########################################################################## 
########################################################################## 



########################################################################## 
########################################################################## 
def console_get():
	for area in bpy.context.screen.areas:
		if area.type == 'CONSOLE':
			for space in area.spaces:
				if space.type == 'CONSOLE':
					return area, space
	return None, None
########################################################################## 
def cwrite(text):
	area, space = console_get()
	if space is None:
		return

	context = bpy.context.copy()
	context.update(dict(
		space=space,
		area=area,
	))
	for line in text.split("\n"):
		bpy.ops.console.scrollback_append(context, text=line, type='OUTPUT')

########################################################################## 
########################################################################## 
def UpdateView():
    """Refresh the active view layer to reflect changes in the scene."""
    bpy.context.view_layer.update()

########################################################################## 
#region Scene 
def Get_Scene():
	return bpy.context.scene
########################################################################## 		 
def GS():
	return Get_Scene()
########################################################################## 	 
def Current_Frame(val = None):
	if val is None:
		return GS().frame_current
	else:
		GS().frame_current = val
########################################################################## 
def CF(val=None):
	return Current_Frame(val)
########################################################################## 
# Test if Object exists 
def Exist_Object(ref):
	if is_string(ref):
		if ref in bpy.data.objects:
			return True
		else:
			return False
	else:
		if ref.name in bpy.data.objects:
			return True
		else:
			return False
########################################################################## 
# Rename Object 
# oba-name or object ID 
def Rename_Object(oba,name="NewName"):
	obj=Get_Object_Any(oba)
	objref = None
# obj is string 
	if is_string(obj):
		objref = Get_Object_Any(obj)
	else:
		objref = obj
# set name - only if string 
	if is_string(name):
		objref.name = name
		return True
	else:
		return False
########################################################################## 
#endregion 
########################################################################## 
# 
########################################################################## 
#region RENDER SETTINGS 
# ('BLENDER_EEVEE', 'BLENDER_WORKBENCH', 'CYCLES', 'POVRAY_RENDER', 'APPLESEED_RENDER', 'RPR', 'LUXCORE') 
def Set_Render_Engine(Engine="CYCLES"):
	bpy.context.scene.render.engine =Engine
########################################################################## 
def Set_Render_Cycles():
	Set_Render_Engine('CYCLES')
########################################################################## 
def Set_Render_Eevee():
	Set_Render_Engine('BLENDER_EEVEE')
########################################################################## 
def Set_Render_RPR():
	Set_Render_Engine("RPR")
########################################################################## 
def Set_Render_POV():
	Set_Render_Engine("POVRAY_RENDER")
########################################################################## 
def Set_Render_Luxcore():
	Set_Render_Engine("LUXCORE")
########################################################################## 
def Render_Image(use_view = False):
	bpy.ops.render.render(use_viewport=use_view)
	res=bpy.data.images['Render Result']
	return res
########################################################################## 
def Render_Animation(use_view = False):
	res=bpy.ops.render.render(animation=True, use_viewport=use_view)
	return res
########################################################################## 
def Render_Set_Resolution(x=3840,y=2160):
	GS().render.resolution_x = x
	GS().render.resolution_y = y
########################################################################## 
def Render_Get_Resolution():
	res=[]
	res.append(GS().render.resolution_x)
	res.append(GS().render.resolution_y)
	return res
########################################################################## 
def Render_Set_Percentage(p):
	get_scene().render.resolution_percentage = p
########################################################################## 
def Render_Get_Percentage():
	res=get_scene().render.resolution_percentage
	return res
########################################################################## 
def Render_Set_Aspect(x,y):
	GS().render.pixel_aspect_x = x
	GS().render.pixel_aspect_y = y
########################################################################## 
def Render_Get_Aspect():
	res = []
	res.append(get_scene().render.pixel_aspect_x)
	res.append(get_scene().render.pixel_aspect_y)
	return res
########################################################################## 
def Render_Set_FPS(val, ba = 1.0):
	GS().render.fps = val
	GS().render.fps_base = ba
########################################################################## 
#endregion 
########################################################################## 

########################################################################## 
#region OBJECTS 
########################################################################## 
# 
def Create_Object(name, col = None):
	m = bpy.data.meshes.new(name)
	o = bpy.data.objects.new(name, m)
	col_ref = None
	if col == None:
		col_ref=bpy.context.view_layer.active_layer_collection.collection
	elif is_string(col):
		if col in bpy.data.collections:
			col_ref = bpy.data.collections[col]
		else:
			col_ref = Create_Collection(col)
	else:
		col_ref = col
	col_ref.objects.link(o)
	return o
########################################################################## 
def Copy_Object(tocopy, col = None):
	new_obj = None
	to_copy = None
	col_ref = None
	if is_string(tocopy):
		to_copy = Get_Object_Any(tocopy)
	else:
		to_copy = tocopy
	if col == None:
		col_ref=bpy.context.view_layer.active_layer_collection.collection
	elif is_string(col):
		if Exists_Collection(col):
			col_ref = Get_Collection(col)
		else:
			col_ref = Create_Collection(col)
	else:
		col_ref = col
	new_obj = to_copy.copy()
	if new_obj.data is not None:
		new_obj.data = to_copy.data.copy()
	new_obj.animation_data_clear()
	col_ref.objects.link(new_obj)
	return new_obj
########################################################################## 
#region COLLECTIONS 
########################################################################## 
#Make new Collection 
def NewCollection(name):
#Linking collections 
# Create new collection 
	col = bpy.data.collections.new(name)
# The collection hasn't been added as children of the root collection 
# Need to do this step to be visible in outline 
	root_col = bpy.context.scene.collection
	root_col.children.link(col)
	return col
########################################################################## 
def LinkToCollection(col,oba):
	obj=Get_Object_Any(oba)
	col.objects.link(obj)
########################################################################## 
def UnlinkObjFromScene(oba):
	obj=Get_Object_Any(oba)
	scene = bpy.context.scene
	scene.collection.objects.unlink(obj)
#asz=bpy.context.scene.collection 
#asz.unlink(obj) 
########################################################################## 
def Link_Obj_to_Scene(oba):
	obj=Get_Object_Any(oba)
	scene = bpy.context.scene
	scene.collection.objects.link(obj)
########################################################################## 
def MoveObjToCollection(col,oba):
	obj=Get_Object_Any(oba)
	LinkToCollection(col,obj)
	UnlinkObjFromScene(obj)
########################################################################## 
def Create_Collection(name):
	if  Exists_Collection(name) is False:
		bpy.data.collections.new(name)
		colref = bpy.data.collections[name]
		bpy.context.scene.collection.children.link(colref)
	else:
		colref=False
	return colref
########################################################################## 
def Delete_Collection(name, delete_objects = False):
# Make sure collection exists 
	if Exists_Collection(name):
# String or reference check 
		if is_string(name):
			col = Get_Collection(name)
		else:
			col = name
# See if deleting the children 
		if delete_objects:
			Deselect_All()
			if len(col.objects) > 0:
				for co in col.objects:
					co.select_set(True)
				delete_selected_objects()
		else:
			Deselect_All()
			if len(col.objects) > 0:
				for co in col.objects:
					bpy.context.scene.collection.objects.link(co)
# Now remove collection 
		bpy.data.collections.remove(col)
	else:
		return False
########################################################################## 
def Remove_Collection(name = "Collection 1"):
	remove_collection_objects = True
	coll = bpy.data.collections.get(name)
	if coll:
		if remove_collection_objects:
			obs = [o for o in coll.objects if o.users == 1]
			while obs:
				bpy.data.objects.remove(obs.pop())
	bpy.data.collections.remove(coll)
########################################################################## 
def delete_objects_in_collection(col):
# setting up colref 
	colref = None
# col is a string 
	if Exists_Collection(col):
		if is_string(col):
			colref = Get_Collection(col)
		else:
			colref = col
# delete all objects in colref 
	Deselect_All()
	for co in colref.objects:
		co.select_set(True)
	delete_selected_objects()
########################################################################## 
def delete_hierarchy(col):
	colref = None
	if is_string(col):
		colref = Get_Collection(col)
	else:
		colref = col
	for co in colref.children:
		if isinstance(co, bpy.types.Collection):
			delete_hierarchy(co)
	Deselect_All()
	delete_objects_in_collection(colref)
	Delete_Collection(colref)
########################################################################## 
def duplicate_collection(col):
	colref = None
	if is_string(col):
		colref = Get_Collection(col)
	else:
		colref = col
	new_name = "Copy of " + colref.name
	new_col = Create_Collection(new_name)
	to_copy = Get_Object_Anys_from_collection(colref.name)
	for o in to_copy:
		copy_object(o,new_col)
	return Get_Collection(new_name)
########################################################################## 
def Get_Object_Anys_from_collection(col):
	if is_string(col):
		return bpy.data.collections[col].objects
	else:
		return col.objects
########################################################################## 
def Get_Collection(ref = None):
	if ref is None:
		return bpy.context.view_layer.active_layer_collection.collection
	else:
		if ref in bpy.data.collections:
			return bpy.data.collections[ref]
		else:
			return False
########################################################################## 
# 
########################################################################## 
# Get active Collection 
def Collection_Get_Active():
	res=bpy.context.view_layer.active_layer_collection.collection
	return res
########################################################################## 
def Collection_Set_Active(ref):
	colref = None
	if is_string(ref):
		colref = Get_Collection(ref)
	else:
		colref = ref
	if colref.name in bpy.data.collections:
		bpy.context.view_layer.active_layer_collection = bpy.context.view_layer.layer_collection.children[colref.name]
	else:
		return False
########################################################################## 
def Get_all_Collections():
	res=bpy.data.collections
	return res
########################################################################## 

########################################################################## 
def Link_Object_to_Collection(ref, col):
	if is_string(col):
		if is_string(ref):
			objref = Get_Object_Any(ref)
			bpy.data.collections[col].objects.link(objref)
		else:
			bpy.data.collections[col].objects.link(ref)
	else:
		if is_string(ref):
			objref = Get_Object_Any(ref)
			col.objects.link(objref)
		else:
			col.objects.link(ref)
########################################################################## 
def Link_Objects_to_Collection(ref, col):
	if is_string(col):
		for o in ref:
			bpy.data.collections[col].objects.link(o)
	else:
		for o in ref:
			col.objects.link(o)
		pass
########################################################################## 
def Unlink_Object_from_Collection(ref, col):
#ref.users_collection[0].unlink(ref) 
	if is_string(col):
		if is_string(ref):
			objref = Get_Object_Any(ref)
			bpy.data.collections[col].objects.unlink(objref)
		else:
			bpy.data.collections[col].objects.unlink(ref)
	else:
		if is_string(ref):
			objref = Get_Object_Any(ref)
			col.objects.unlink(objref)
		else:
			col.objects.unlink(ref)
########################################################################## 
# we assume that lis is a list 
def Unlink_Objects_from_Collection(lis, col):
	colref = None

	if is_string(col):
		colref = Get_Collection(col)
	else:
		colref = col

	for o in lis:
		colref.objects.unlink(o)
########################################################################## 
def Move_Object_to_Collection(ref, col):

	objref = None
	colref = None

	if is_string(ref):
		objref = Get_Object_Any(ref)
	else:
		objref = ref

	if is_string(col):
		colref = Get_Collection(col)
	else:
		colref = col

	cols = objref.users_collection
	for c in cols:
		c.objects.unlink(objref)
	Link_Object_to_Collection(objref, colref)
########################################################################## 
# we assume that ref is object list 
def Move_Objects_to_Collection(ref, col):
	colref = None
	if is_string(col):
		colref = Get_Collection(col)
	else:
		colref = col
	for o in ref:
		for c in o.users_collection:
			c.objects.unlink(o)
		Link_Object_to_Collection(o, colref)
########################################################################## 
def Get_Object_Any_collection(ref):
	objref = None
	if is_string(ref):
		objref = Get_Object_Any(ref)
	else:
		objref = ref
	return objref.users_collection[0]
########################################################################## 
def Get_Object_Any_collections(ref):
	objref = None
	if is_string(ref):
		objref = Get_Object_Any(ref)
	else:
		objref = ref
	return objref.users_collection
########################################################################## 
def Exists_Collection(col):
	if is_string(col):
		if col in bpy.data.collections:
			return True
		else:
			return False
	else:
		if col.name in bpy.data.collections:
			return True
		else:
			return False
#endregion 
########################################################################## 
#region OBJECTS - SELECTION 
def select_all_meshes():
	bpy.ops.object.select_by_type(type='MESH')
########################################################################## 
def select_all_curves():
	bpy.ops.object.select_by_type(type='CURVE')
########################################################################## 
def select_all_surfaces():
	bpy.ops.object.select_by_type(type='SURFACE')
########################################################################## 
def select_all_metas():
	bpy.ops.object.select_by_type(type='META')
########################################################################## 
def select_all_text():
	bpy.ops.object.select_by_type(type='FONT')
########################################################################## 
def select_all_hair():
	bpy.ops.object.select_by_type(type='HAIR')
########################################################################## 
def select_all_point_clouds():
	bpy.ops.object.select_by_type(type='POINTCLOUD')
########################################################################## 
def select_all_volumes():
	bpy.ops.object.select_by_type(type='VOLUME')
########################################################################## 
def select_all_armatures():
	bpy.ops.object.select_by_type(type='ARMATURE')
########################################################################## 
def select_all_lattices():
	bpy.ops.object.select_by_type(type='LATTICE')
########################################################################## 
def select_all_empties():
	bpy.ops.object.select_by_type(type='EMPTY')
########################################################################## 
def select_all_greace_pencils():
	bpy.ops.object.select_by_type(type='GPENCIL')
########################################################################## 
def select_all_cameras():
	bpy.ops.object.select_by_type(type='CAMERA')
########################################################################## 
def select_all_speakers():
	bpy.ops.object.select_by_type(type='SPEAKER')
########################################################################## 
def select_all_light_probes():
	bpy.ops.object.select_by_type(type='LIGHT_PROBE')
########################################################################## 
def invert_selection():
	bpy.ops.object.select_all(action='INVERT')
########################################################################## 
#endregion 
########################################################################## 
#region VISIBILITY 
########################################################################## 
def Hide_Object(ref=None):
	if ref is not None:
# ref is string 
		if is_string(ref):
			if Exist_Object(ref):
				obj = Get_Object_Any(ref)
				obj.hide_set(True)
			pass
# ref is object reference 
		else:
			if Exist_Object(ref):
				ref.hide_set(True)
	else:
		obj = selected_object()
		if obj is not None:
			obj.hide_set(True)
########################################################################## 

########################################################################## 
def Show_Object(ref = None):
	if ref is not None:
# ref is string 
		if is_string(ref):
			if Exist_Object(ref):
				obj = Get_Object_Any(ref)
				obj.hide_set(False)
			pass
# ref is object reference 
		else:
			if Exist_Object(ref):
				ref.hide_set(False)
	else:
		obj = selected_object()
		if obj is not None:
			obj.hide_set(False)
########################################################################## 

########################################################################## 

########################################################################## 
def UnHide_Object(ref = None):
	Show_Object(ref)
########################################################################## 
# ref is an object reference or a string 
def Hide_in_Viewport(ref):
	if is_string(ref):
		if Exist_Object(ref):
			obj = Get_Object_Any(ref)
			obj.hide_viewport = True
	else:
		if Exist_Object(ref):
			ref.hide_viewport = True
		else:
			return False
########################################################################## 
def Show_in_Viewport(ref):
	if is_string(ref):
		if Exist_Object(ref):
			obj = Get_Object_Any(ref)
			obj.hide_viewport = False
	else:
		if Exist_Object(ref):
			ref.hide_viewport = False
		else:
			return False
########################################################################## 

########################################################################## 
def Hide_in_Render(ref):
	if is_string(ref):
		if Exist_Object(ref):
			obj = Get_Object_Any(ref)
			obj.hide_render = True
	else:
		if Exist_Object(ref):
			ref.hide_render = True
		else:
			return False
########################################################################## 
def Show_in_Render(ref):
	if is_string(ref):
		if Exist_Object(ref):
			obj = Get_Object_Any(ref)
			obj.hide_render = False
	else:
		if Exist_Object(ref):
			ref.hide_render = False
		else:
			return False
########################################################################## 

########################################################################## 
def Display_as_Bounds(ref):
	if is_string(ref):
		if Exist_Object(ref):
			obj = Get_Object_Any(ref)
			obj.display_type = 'BOUNDS'
	else:
		if Exist_Object(ref):
			ref.display_type = 'BOUNDS'
		else:
			return False
########################################################################## 
def Display_as_Textured(ref):
	if is_string(ref):
		if Exist_Object(ref):
			obj = Get_Object_Any(ref)
			obj.display_type = 'TEXTURED'
	else:
		if Exist_Object(ref):
			ref.display_type = 'TEXTURED'
		else:
			return False
########################################################################## 
def Display_as_Solid(ref):
	if is_string(ref):
		if Exist_Object(ref):
			obj = Get_Object_Any(ref)
			obj.display_type = 'SOLID'
	else:
		if Exist_Object(ref):
			ref.display_type = 'SOLID'
		else:
			return False
########################################################################## 
def Display_as_Wire(ref):
	if is_string(ref):
		if Exist_Object(ref):
			obj = Get_Object_Any(ref)
			obj.display_type = 'WIRE'
	else:
		if Exist_Object(ref):
			ref.display_type = 'WIRE'
		else:
			return False
#endregion 
########################################################################## 
#region TRANSFORMATIONS 
def Trans_Location(oba = None, loc = None):
	obj=Get_Object_Any(oba)
# set up vars 
	objref = None
	obj_provided = False
	loc_provided = False

# obj checks 
	if obj is not None:
		obj_provided = True
# obj has been provided 
		if is_string(obj):
			objref = Get_Object_Any(obj)
		else:
			objref = obj

# loc checks 
	if loc is not None:
# loc has been provided 
		loc_provided = True

	if obj_provided:
# obj has been provided 
		if loc_provided:
# case 1 - obj and loc provided 
			objref.location = Vector((loc[0],loc[1],loc[2]))
		else:
# case 2 - obj but no loc provided 
			return objref.location
	else:
# obj has not been provided 
		if loc_provided:
# case 3 - obj not provided but loc is 
			objref = so()
			objref.location = Vector((loc[0],loc[1],loc[2]))
		else:
# case 4 - no obj and no loc provided 
			return so().location
########################################################################## 
def Trans_Rotation(oba = None, rot = None):
	obj=Get_Object_Any(oba)
# set up vars 
	objref = None
	obj_provided = False
	rot_provided = False

# obj checks 
	if obj is not None:
		obj_provided = True
# obj has been provided 
		if is_string(obj):
			objref = Get_Object_Any(obj)
		else:
			objref = obj

# newloc checks 
	if rot is not None:
# rot has been provided 
		rot_provided = True

	if obj_provided:
# obj has been provided 
		if rot_provided:
# case 1 - obj and rot provided 
			objref.rotation_euler[0] = rot[0]
			objref.rotation_euler[1] = rot[1]
			objref.rotation_euler[2] = rot[2]
		else:
# case 2 - obj but no rot provided 
			return objref.rotation_euler
	else:
# obj has not been provided 
		if rot_provided:
# case 3 - obj not provided but rot is 
			objref = so()
			objref.rotation_euler[0] = rot[0]
			objref.rotation_euler[1] = rot[1]
			objref.rotation_euler[2] = rot[2]
		else:
# case 4 - no obj and no rot provided 
			return so().rotation_euler
########################################################################## 
def Trans_Scale(oba = None, scale = None):
	obj=Get_Object_Any(oba)
# set up vars 
	objref = None
	obj_provided = False
	scale_provided = False

# obj checks 
	if obj is not None:
		obj_provided = True
# obj has been provided 
		if is_string(obj):
			objref = Get_Object_Any(obj)
		else:
			objref = obj

# newloc checks 
	if scale is not None:
# rot has been provided 
		scale_provided = True

	if obj_provided:
# obj has been provided 
		if scale_provided:
# case 1 - obj and scale provided 
			objref.scale[0] = scale[0]
			objref.scale[1] = scale[1]
			objref.scale[2] = scale[2]
		else:
# case 2 - obj but no scale provided 
			return objref.scale
	else:
# obj has not been provided 
		if scale_provided:
# case 3 - obj not provided but scale is 
			objref = so()
			objref.scale[0] = scale[0]
			objref.scale[1] = scale[1]
			objref.scale[2] = scale[2]
		else:
# case 4 - no obj and no scale provided 
			return so().scale
	pass
########################################################################## 
# Applying Transformations: 
########################################################################## 
def Apply_Location(oba = None):
	ref=Get_Object_Any(oba)
	print("Apply Loc.:"+str(ref))
	if ref is not None:
		Deselect_All()
		SelectObject(ref)
	bpy.ops.object.transform_apply(location=True, rotation=False, scale=False)
########################################################################## 
def Apply_Rotation(oba = None):
	ref=Get_Object_Any(oba)
	if ref is not None:
		Deselect_All()
		SelectObject(ref)
	bpy.ops.object.transform_apply(location=False, rotation=True, scale=False)
########################################################################## 
def Apply_Scale(oba = None):
	ref=Get_Object_Any(oba)
	if ref is not None:
		Deselect_All()
		SelectObject(ref)
	bpy.ops.object.transform_apply(location=False, rotation=False, scale=True)
########################################################################## 
def Apply_all_Transforms(oba = None):
	ref=Get_Object_Any(oba)
	if ref is not None:
		Deselect_All()
		SelectObject(ref)
	bpy.ops.object.transform_apply(location=True, rotation=True, scale=True)
########################################################################## 
def Apply_Rotation_and_Scale(oba = None):
	ref=Get_Object_Any(oba)
	if ref is not None:
		Deselect_All()
		SelectObject(ref)
	bpy.ops.object.transform_apply(location=False, rotation=True, scale=True)
########################################################################## 
# Translations: 
########################################################################## 
def Translate_Vector(vec, ref = None):
	obj = Get_Object_Any(ref)
	obj.location[0] += vec[0]
	obj.location[1] += vec[1]
	obj.location[2] += vec[2]
########################################################################## 
def Translate_Along_Axis(val, axis : Vector, ref = None):
	objref = None
	if ref is not None:
		if is_string(ref):
			objref = Get_Object_Any(ref)
		else:
			objref = ref
	else:
		objref = Get_Active_Object()

	axis.normalize()
	objref.location[0] += (val * axis[0])
	objref.location[1] += (val * axis[1])
	objref.location[2] += (val * axis[2])
########################################################################## 
# Uses GLOBAL Axis 
def Translate_Along_X(val, ref = None):
	Translate_Along_Axis(val, Vector((1.0,0.0,0.0)), ref)
########################################################################## 
# Uses GLOBAL Axis 
def Translate_Along_Y(val, ref = None):
	Translate_Along_Axis(val, Vector((0.0,1.0,0.0)), ref)
########################################################################## 
# Uses GLOBAL Axis 
def Translate_Along_Z(val, ref = None):
	Translate_Along_Axis(val, Vector((0.0,0.0,1.0)), ref)
########################################################################## 

########################################################################## 
def Translate_along_Local_x(val, ref = None):
	objref = Get_Object_Any(ref)
	axis = Vector((1.0,0.0,0.0))
	axis.rotate(objref.rotation_euler)
	Translate_Along_Axis(val, axis, ref)
########################################################################## 
def Translate_along_Local_y(val, ref = None):
	objref = Get_Object_Any(ref)
	axis = Vector((0.0,1.0,0.0))
	axis.rotate(objref.rotation_euler)
	Translate_Along_Axis(val, axis, ref)
########################################################################## 
def Translate_along_Local_z(val, ref = None):
	objref = Get_Object_Any(ref)
	axis = Vector((0.0,0.0,1.0))
	axis.rotate(objref.rotation_euler)
	Translate_Along_Axis(val, axis, ref)
########################################################################## 
# Rotations: 
# 
def Rotate_Vector(vec, ref = None):
	objref = Get_Object_Any(ref)
	objref.rotation_euler[0] += vec[0]
	objref.rotation_euler[1] += vec[1]
	objref.rotation_euler[2] += vec[2]
########################################################################## 
def Rotate_around_Axis(deg, axis, obj = None, point = None):
	objref = Get_Object_Any(obj)
	pointref = None
	if point is None:
		if get_scene().tool_settings.transform_pivot_point == 'MEDIAN_POINT':
			pointref = objref.location
		elif get_scene().tool_settings.transform_pivot_point == 'CURSOR':
			pointref = Get_Cursor_Location()
		else:
			pointref = objref.location
	else:
		pointref = point

	axis.normalize()
	mat = (Matrix.Translation(pointref) @ Matrix.Rotation(math.radians(deg), 4, axis) @ Matrix.Translation(-pointref))
	objref.matrix_world = mat @ objref.matrix_world
########################################################################## 
def Rotate_around_Global_x(deg, obj = None, point = None):
	Rotate_around_Axis(deg, Vector((1.0,0.0,0.0)), obj, point)
########################################################################## 
def Rotate_around_Global_y(deg, obj = None, point = None):
	Rotate_around_Axis(deg, Vector((0.0,1.0,0.0)), obj, point)
########################################################################## 
def Rotate_around_Global_z(deg, obj = None, point = None):
	Rotate_around_Axis(deg, Vector((0.0,0.0,1.0)), obj, point)
########################################################################## 
def Rotate_around_x(deg, obj = None, point = None):
	Rotate_around_Global_x(deg, obj, point)
########################################################################## 
def Rotate_around_y(deg, obj = None, point = None):
	Rotate_around_Global_y(deg, obj, point)
########################################################################## 
def Rotate_around_z(deg, obj = None, point = None):
	Rotate_around_Global_z(deg, obj, point)
########################################################################## 
def Rotate_around_Local_x(deg, obj = None, point = None):
	objref = Get_Object_Any(obj)
	axis = Vector((1.0,0.0,0.0))
	axis.rotate(objref.rotation_euler)
	Rotate_around_Axis(deg, axis, obj, point)
########################################################################## 
def Rotate_around_Local_y(deg, obj = None, point = None):
	objref = Get_Object_Any(obj)
	axis = Vector((0.0,1.0,0.0))
	axis.rotate(objref.rotation_euler)
	Rotate_around_Axis(deg, axis, obj, point)
########################################################################## 
def Rotate_around_Local_z(deg, obj = None, point = None):
	objref = Get_Object_Any(obj)
	axis = Vector((0.0,0.0,1.0))
	axis.rotate(objref.rotation_euler)
	Rotate_around_Axis(deg, axis, obj, point)
########################################################################## 
def Revese_Rotation_on_Euler(rot : Euler):
	if rot is not None:
		temp = rot
		temp.x *= -1
		temp.y *= -1
		temp.z *= -1
		temp.order = 'ZYX'
		res=True
	else:
		res=False
	return res
########################################################################## 
# Scaling: 
########################################################################## 
def Scale_Vector(vec, ref = None):
	obj = Get_Object_Any(ref)
	obj.scale[0] *= vec[0]
	obj.scale[1] *= vec[1]
	obj.scale[2] *= vec[2]
########################################################################## 
def Scale_Uniform(val, ref = None, point = None):
	Scale_Vector(Vector((val, val, val)), ref)
########################################################################## 
def Scale_along_Axis(factor, axis, ref = None, point = None):
	obj = Get_Object_Any(ref)
	pointref = None
	if point is None:
		if get_scene().tool_settings.transform_pivot_point == 'MEDIAN_POINT':
			pointref = obj.location
		elif get_scene().tool_settings.transform_pivot_point == 'CURSOR':
			pointref = Get_Cursor_Location()
		else:
			pointref = obj.location
	else:
		pointref = point

	axis.normalize()
	temp = Vector()
	temp[0] = 1 + ((factor - 1)/(1 - 0)) * (axis[0] - 0)
	temp[1] = 1 + ((factor - 1)/(1 - 0)) * (axis[1] - 0)
	temp[2] = 1 + ((factor - 1)/(1 - 0)) * (axis[2] - 0)
	obj.scale[0] *= temp[0]
	obj.scale[1] *= temp[1]
	obj.scale[2] *= temp[2]

	axis.rotate(obj.rotation_euler)
	axis.normalize()
	fac = (obj.location - pointref).dot(axis) * (factor-1)
	Translate_Along_Axis(fac, axis, obj)
########################################################################## 
def Scale_along_x(factor, ref = None, point = None):
	Scale_along_Axis(factor, Vector((1.0, 0.0, 0.0)), ref, point)
########################################################################## 
def Scale_along_y(factor, ref = None, point = None):
	Scale_along_Axis(factor, Vector((0.0, 1.0, 0.0)), ref, point)
########################################################################## 
def Scale_along_z(factor, ref = None, point = None):
	Scale_along_Axis(factor, Vector((0.0, 0.0, 1.0)), ref, point)
########################################################################## 
def Scale_along_Local_x(factor, ref = None, point = None):
	Scale_along_Axis(factor, Vector((1.0, 0.0, 0.0)), ref, point)
########################################################################## 
def Scale_along_Local_y(factor, ref = None, point = None):
	Scale_along_Axis(factor, Vector((0.0, 1.0, 0.0)), ref, point)
########################################################################## 
def Scale_along_Local_z(factor, ref = None, point = None):
	Scale_along_Axis(factor, Vector((0.0, 0.0, 1.0)), ref, point)
########################################################################## 
def Scale_along_Global_axis(factor, axis : Vector, ref = None, pointref = None):
	obj = Get_Object_Any(ref)
	point = None
	if pointref is None:
		if get_scene().tool_settings.transform_pivot_point == 'MEDIAN_POINT':
			point = obj.location
		elif get_scene().tool_settings.transform_pivot_point == 'CURSOR':
			point = Get_Cursor_Location()
		else:
			point = obj.location
	else:
		point = point
	loc, rot, scale = obj.matrix_world.decompose()
	loc_mat = Matrix.Translation(loc)
	new_loc_mat = loc_mat.copy()
	new_loc_mat.invert()
	obj.matrix_world = new_loc_mat @ obj.matrix_world
	orig_rot = obj.rotation_euler.copy()
	orig_loc = obj.location
	obj.matrix_world = Matrix.Scale(factor, 4, axis) @ obj.matrix_world
	obj.matrix_world = loc_mat @ obj.matrix_world
	obj.rotation_euler = orig_rot
	fac = (obj.location - point).dot(axis) * (factor-1)
	Translate_Along_Axis(fac, axis, obj)
########################################################################## 
def Scale_along_Global_x(factor, ref = None, point = None):
	Scale_along_Global_axis(factor, Vector((1.0, 0.0, 0.0)), ref, point)
########################################################################## 
def Scale_along_Global_y(factor, ref = None, point = None):
	Scale_along_Global_axis(factor, Vector((0.0, 1.0, 0.0)), ref, point)
########################################################################## 
def Scale_along_Global_z(factor, ref = None, point = None):
	Scale_along_Global_axis(factor, Vector((0.0, 0.0, 1.0)), ref, point)
########################################################################## 
# 
def Scale_perpendicular_to_X(fac, ref = None, point = None):
	Scale_Vector(Vector((1.0, fac, fac)), ref)

	obj = Get_Object_Any(ref)
	pointref = None
	if point is None:
		if get_scene().tool_settings.transform_pivot_point == 'MEDIAN_POINT':
			pointref = obj.location
		elif get_scene().tool_settings.transform_pivot_point == 'CURSOR':
			pointref = Get_Cursor_Location()
		else:
			pointref = obj.location
	else:
		pointref = point

	axis = (obj.location - pointref) * Vector((0.0, 1.0, 1.0))
	factor = axis.magnitude * (fac-1)
	Translate_Along_Axis(factor, axis, obj)
########################################################################## 
def Scale_perpendicular_to_Y(fac, ref = None, point = None):
	Scale_Vector(Vector((fac, 1.0, fac)), ref)

	obj = Get_Object_Any(ref)
	pointref = None
	if point is None:
		if get_scene().tool_settings.transform_pivot_point == 'MEDIAN_POINT':
			pointref = obj.location
		elif get_scene().tool_settings.transform_pivot_point == 'CURSOR':
			pointref = Get_Cursor_Location()
		else:
			pointref = obj.location
	else:
		pointref = point

	axis = (obj.location - pointref) * Vector((1.0, 0.0, 1.0))
	factor = axis.magnitude * (fac-1)
	Translate_Along_Axis(factor, axis, obj)
########################################################################## 
def Scale_perpendicular_to_Z(fac, ref = None, point = None):
	Scale_Vector(Vector((fac, fac, 1.0)), ref)

	obj = Get_Object_Any(ref)
	pointref = None
	if point is None:
		if get_scene().tool_settings.transform_pivot_point == 'MEDIAN_POINT':
			pointref = obj.location
		elif get_scene().tool_settings.transform_pivot_point == 'CURSOR':
			pointref = Get_Cursor_Location()
		else:
			pointref = obj.location
	else:
		pointref = point

	axis = (obj.location - pointref) * Vector((1.0, 1.0, 0.0))
	factor = axis.magnitude * (fac-1)
	Translate_Along_Axis(factor, axis, obj)
########################################################################## 
#endregion 
########################################################################## 
#region 3D CURSOR 
########################################################################## 
def Selection_to_Cursor_without_Offset():
	bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)
########################################################################## 
def Selection_to_Cursor_with_Offset():
	bpy.ops.view3d.snap_selected_to_cursor(use_offset=True)
########################################################################## 
def Cursor_to_World_Origin():
	bpy.ops.view3d.snap_cursor_to_center()
########################################################################## 
def Cursor_to_Selection():
	bpy.ops.view3d.snap_cursor_to_selected()
########################################################################## 
def Cursor_to_Active():
	bpy.ops.view3d.snap_cursor_to_selected()
########################################################################## 
def Selection_to_Grid():
	bpy.ops.view3d.snap_selected_to_grid()
########################################################################## 
def Selection_to_Active():
	bpy.ops.view3d.snap_selected_to_active()
########################################################################## 
def Cursor_to_Grid():
	bpy.ops.view3d.snap_Cursor_to_Grid()
########################################################################## 
def Get_Cursor_Location():
	return bpy.context.scene.cursor.location
########################################################################## 
def Set_Cursor_Location(newloc):
	bpy.context.scene.cursor.location = newloc
########################################################################## 
def Get_Cursor_Rotation():
	return bpy.context.scene.cursor.rotation_euler
########################################################################## 
def Get_Cursor_Rotation_Mode():
	return bpy.context.scene.cursor.rotation_mode
########################################################################## 
#endregion 
########################################################################## 
#region PIVOT POINT 
def Pivot_Point_to_Cursor():
	get_scene().tool_settings.transform_pivot_point = 'CURSOR'
########################################################################## 
def Pivot_Point_to_Median():
	get_scene().tool_settings.transform_pivot_point = 'MEDIAN_POINT'
########################################################################## 
def Pivot_Point_to_individual_Origin():
	get_scene().tool_settings.transform_pivot_point = 'INDIVIDUAL_ORIGINS'
########################################################################## 
def Pivot_Point_to_Active_Element():
	get_scene().tool_settings.transform_pivot_point = 'ACTIVE_ELEMENT'
########################################################################## 
def Pivot_Point_to_bounding_Box_Center():
	get_scene().tool_settings.transform_pivot_point = 'BOUNDING_BOX_CENTER'
#endregion 

########################################################################## 
# Surface 
def Origin_to_Centermass(ref = None):
	objref = Get_Object_Any(ref)
	if objref is not None:
		Select_Object(objref)
	bpy.ops.object.origin_set(type='ORIGIN_CENTER_OF_MASS')
########################################################################## 

########################################################################## 
# volume 
def Origin_to_Center_Volume(ref = None):
	objref = Get_Object_Any(ref)
	if objref is not None:
		Select_Object(objref)
	bpy.ops.object.origin_set(type='ORIGIN_CENTER_OF_VOLUME')
########################################################################## 
#endregion 
########################################################################## 
# 
########################################################################## 
#region SHADING 
def Shade_Smooth(ref = None):
	objref = None
	if ref is not None:
		if is_string(ref):
			objref = Get_Object_Any(ref)
		else:
			objref = ref
	else:
# nothing supplied, use so 
		objref = Get_Active_Object()
	Deselect_All()
	SelectObject(ref)
	bpy.ops.object.shade_smooth()
########################################################################## 
def Shade_Flat(ref = None):
	objref = None
	if ref is not None:
		if is_string(ref):
			objref = Get_Object_Any(ref)
		else:
			objref = ref
	else:
# nothing supplied, use so 
		objref = Get_Active_Object()
	Deselect_All()
	SelectObject(ref)
	bpy.ops.object.shade_flat()
########################################################################## 
def Set_Smooth_Angle(ref, degrees = 60):
	objref = None
	if is_string(ref):
		objref = Get_Object_Any(ref)
	else:
		objref = ref
	if objref.data.use_auto_smooth == False:
		objref.data.use_auto_smooth = True
	objref.data.auto_smooth_angle = radians(degrees)
########################################################################## 
#endregion 
########################################################################## 
# 
########################################################################## 
#region MESHES 
########################################################################## 
# Creates a mesh - (string) name 
def Mesh_Create(name):
	return bpy.data.meshes.new(name)
########################################################################## 
def Vertices_Get(ref):
	if is_string(ref):
		return Get_Object_Any(ref).data.vertices
	else:
		return ref.data.vertices
########################################################################## 
def Edges_Get(ref):
	if is_string(ref):
		return Get_Object_Any(ref).data.edges
	else:
		return ref.data.edges
########################################################################## 
def Faces_Get(ref):
	return Poly_Get(ref)
########################################################################## 
# Get Polygons 
def Poly_Get(ref):
	if is_string(ref):
		return Get_Object_Any(ref).data.polygons
	else:
		return ref.data.polygons
########################################################################## 
def Mesh_from_Object(ref):
	objref = None
	if is_string(ref):
		objref = Get_Object_Any(ref)
	else:
		objref = ref
	res=objref.data
	return res
#endregion 
########################################################################## 
########################################################################## 
# bpy.context.area.type = '?' 
# Context:('VIEW_3D', 'IMAGE_EDITOR', 'NODE_EDITOR', 'SEQUENCE_EDITOR', 'CLIP_EDITOR', 'DOPESHEET_EDITOR', 'GRAPH_EDITOR', 'NLA_EDITOR', 'TEXT_EDITOR', 'CONSOLE', 'INFO', 'TOPBAR', 'STATUSBAR', 'OUTLINER', 'PROPERTIES', 'FILE_BROWSER', 'PREFERENCES') 
# cont = bpy.context.area.type 
# print(str(cont)) 
########################################################################## 

########################################################################## 
########################################################################## 
# Add Basic Objects 
########################################################################## 
########################################################################## 
# type='MESH', 'CURVE', 'SURFACE', 'META', 'FONT', 'VOLUME', 'ARMATURE', 'LATTICE', 'EMPTY', 'GPENCIL', 'CAMERA', 'LIGHT', 'SPEAKER', 'LIGHT_PROBE' 
def Add_Object(type):
		bpy.ops.object.add(radius=1.0, type='EMPTY', enter_editmode=False, align='WORLD', location=(0.0, 0.0, 0.0), rotation=(0.0, 0.0, 0.0))
########################################################################## 
def Add_Empty(type):
		bpy.ops.object.empty_add(type='PLAIN_AXES', radius=1.0, align='WORLD', location=(0.0, 0.0, 0.0), rotation=(0.0, 0.0, 0.0))
########################################################################## 
# type = 'BALL', 'CAPSULE', 'PLANE', 'ELLIPSOID', 'CUBE' 
# 
def Add_MetaBall():
	bpy.ops.object.metaball_add(type='BALL', radius=2.0, enter_editmode=False, align='WORLD', location=(0.0, 0.0, 0.0), rotation=(0.0, 0.0, 0.0))
########################################################################## 
def Add_Light():
	bpy.ops.object.light_add(type='POINT', radius=1.0, align='WORLD', location=(0.0, 0.0, 0.0), rotation=(0.0, 0.0, 0.0))

########################################################################## 
def AddCamera(xn="Camera"):
	camdata = bpy.data.cameras.new(name=xn)
	a = bpy.data.objects.new(name=xn, object_data=camdata)
	bpy.context.scene.collection.objects.link(a)
	bpy.context.object.data.clip_end = 1e+06
#SelectObject(a) 
	return a
# select: bpy.data.objects[a.name].select = True 
########################################################################## 
# Add Plane 
def AddPlane(x=0,y=0,z=0,siz=10):
	obj=bpy.ops.mesh.primitive_plane_add(size=siz, enter_editmode=False, location=(x,y,z))
	RB_RigidBodyAdd_Selected('P','B')
	return obj
########################################################################## 
# Add Cube 
def AddCube(x,y,z,siz):
	obj=bpy.ops.mesh.primitive_cube_add(size=siz,location=(x,y,z))
	RB_RigidBodyAdd_Selected('A','B')
	return obj
########################################################################## 
# Add Sphere 
def AddSphere(x=0,y=0,z=1,siz=1):
	obj=bpy.ops.mesh.primitive_uv_sphere_add(radius=siz, enter_editmode=False, location=(x,y,z))
	RB_RigidBodyAdd_Selected('A','S')
	return obj
########################################################################## 
# Add Menger Cube Level bis max. 4 
def AddMenger(x,y,z,siz,lev):
	obj=bpy.ops.mesh.menger_sponge_add(align='WORLD', location=(x,y,z), rotation=(0, 0, 0), level=lev, radius=siz)
	RB_RigidBodyAdd_Selected('A','B')
	return obj
########################################################################## 
def AddRock(x,y,z,siz,lev):
	obj=bpy.ops.mesh.add_mesh_rock(preset_values='1', num_of_rocks=1, scale_X=(0.5*siz, siz), skew_X=-0.5, scale_Y=(0.5*siz, siz), skew_Y=-0.5, scale_Z=(0.5*siz, siz), skew_Z=-0.5, use_scale_dis=True, scale_fac=(1,1,1), deform=3, rough=2, detail=2, display_detail=2, smooth_fac=2, smooth_it=2, use_generate=True, use_random_seed=True, user_seed=1)
	bpy.ops.object.apply_all_modifiers()
	RB_RigidBodyAdd_Selected('A','M')
	return obj
########################################################################## 
########################################################################## 
# 
# Modifiers and Array Modifier 
# 
########################################################################## 
########################################################################## 
# num 0-Recht, 1 - Vorne, 2 - Oben 
def Do_AddArray(num,anz,dist):
	Ina=Remember_Selected()
	cnt=0
	for j in  Ina:
		cnt+=1
		if cnt>1:
			Deselect_All()
			Set_Active_Object(j)
			Inb.append(j)
			AddArray(0,anz,dist)
			AddArray(1,anz,dist)
			AddArray(2,anz,dist)
			Apply_Modifiers()
########################################################################## 
# Object must be seleceted 
# num 0-Recht, 1 - Vorne, 2 - Oben 
# 
def AddArray(num,anz,dist):
	bpy.ops.object.modifier_add(type='ARRAY')
	bpy.context.object.modifiers["Array"].relative_offset_displace[num] = dist
	if num==0:
		a=1
		b=2
	elif num==1:
		a=0
		b=2
	elif num==2:
		a=0
		b=1
	bpy.context.object.modifiers["Array"].relative_offset_displace[a] = 0
	bpy.context.object.modifiers["Array"].relative_offset_displace[b] = 0

	bpy.context.object.modifiers["Array"].count = anz
	bpy.context.object.modifiers["Array"].show_expanded = False

########################################################################## 
def Apply_Modifiers():
	bpy.ops.object.apply_all_modifiers()
	Unjoin_by_Loose_Parts()
########################################################################## 
# number ... 12 
# size ... 1 
# dist ... 0.75 (must be <1 size to explode) 
# typ - '1 - Sphere, 0 - Menger, 2- Cube, 3 - Rock 
# optional parameters: 
# x,y,z - where to place the Object 
# pow -> 0.01 bis 10000 - Weight of objects (Power to destroy) 
# ac - 0/1 - 1-> start deactivated 0 - not deactivated 
# rest - Set Bouncing Factor for Rigib Body 0 ... 1 (please set Floor to same) 
def Do_Axis(number=5,size=1,dist=0.25,tp=1,x=0,y=0,z=0,pow=250,ac=0,rest=0.95):
	if z==0:
		z=size*1.1
	if tp==0:
		AddMenger(x,y,z,size,3) # 3 is level can be 1 to 4
	elif tp==1:
		AddSphere(x,y,z,size)
	elif tp==2:
		AddCube(x,y,z,size)
	else:
		AddRock(x,y,z,size,3)
	RB_Deactivate(ac)
	bpy.context.object.rigid_body.restitution = rest
	bpy.context.object.rigid_body.mass = pow
	AddArray(0,number,dist)
	bpy.ops.object.apply_all_modifiers()
	AddArray(1,number,dist)
	bpy.ops.object.apply_all_modifiers()
	AddArray(2,number,dist)
	Apply_Modifiers()

########################################################################## 
# HOW TO DEBUG. 
# If you have added own Subroutines to the Library, and they are buggy. 
# Or if the Library threw errors because of Changes in Blender. 
# You can use the "Reset Python" Function to reload the Library." 
########################################################################## 
########################################################################## 
# 
# Get, Point - at - Simple Subs 
# 
########################################################################## 
########################################################################## 
# https://blenderartists.org/t/2-80-cheat-sheet-for-updating-add-ons/1148974 
#object.hide_get() # get the hide value {True, False} 
#object.hide_set(True) # set hide to True 
########################################################################## 
def If_Blender_Version(mi=80,mv=2):
	if (mv,mv,0) > bpy.app.version:
		r=False
	else:
		r=True
	return r
########################################################################## 
# Teste ob Blender 2.8 or previouse 
def If_Blender28():
	if (2, 80, 0) > bpy.app.version:
		r=False
	else:
		r=True
	return r
########################################################################## 
# xn = Object-ID 
def Select_Object_by_Name(xn):
	# For Blender 2.7x
	if (2, 80, 0) > bpy.app.version:
		bpy.data.objects[xn].select = True
	else:
		# For 2.8x
		bpy.data.objects[xn].select_set(True)
########################################################################## 
# Works "by name" or by ID 
def SelectObject(xn):
	obj=Get_Object_Any(xn)
	# For Blender 2.7x
	if (2, 80, 0) > bpy.app.version:
		bpy.data.objects[obj.name].select = True
	else:
		# For 2.8x
		bpy.data.objects[obj.name].select_set = True

	#bpy.context.scene.objects["Cube"].select_set(True)
########################################################################## 
# Works by name or by ID 
def Select_Object(oba):
	obj=Get_Object_Any(oba)
	obj.select_set(state=True)
#bpy.context.active_object.select_set(state=True) 
#bpy.context.scene.objects.active = obj 	 
########################################################################## 
# Is Object selected by name 
# For 2.8x 
def Is_Object_Selected_by_name(xn):
	re=bpy.data.objects[xn].select_set(True)
	return re
########################################################################## 
# Is Object selected by name 
# For 2.8x 
def Is_Object_Selected(xn):
	re=bpy.data.objects[xn.name].select_set(True)
	return re
########################################################################## 
# By Name or by ID 
def Set_Active_Object(oba):
	obj=Get_Object_Any(oba)
	if Exists(obj)==0:
		obj=Get_Last_Object()
	Select_Object(obj)
	bpy.context.view_layer.objects.active = obj
########################################################################## 
def Get_Active_Window():
	active=bpy.context.area.spaces.active
	return active

########################################################################## 
# Works by name or with ID 
def Exists(oba):
	obj=Get_Object_Any(oba)
	try:
		if bpy.data.objects.get(obj.name) is not None:
			return 1
		else:
			return 0
	except:
		return 0
########################################################################## 
def Get_Active_Scene():
	active=bpy.context.screen.scene
	return active
########################################################################## 
def Get_3D_Cursor_Pos():
    cursor = bpy.context.scene.cursor
    return cursor.location.x, cursor.location.y, cursor.location.z
########################################################################## 
def Set_3D_Cursor_Pos(x=0, y=0, z=1):
    bpy.context.scene.cursor.location = (x, y, z)
########################################################################## 
# 2.8 tested 
# Works "by name" or with ID 
def Is_object_Selected(oba):
	obj=Get_Object_Any(oba)
#bpy.context.active_object.select_get() 
	return obj.select_get()
########################################################################## 
# [‘MESH’, ‘CURVE’, ‘SURFACE’, ‘META’, ‘FONT’, ‘ARMATURE’, ‘LATTICE’, ‘EMPTY’, ‘CAMERA’, ‘LAMP’, ‘SPEAKER’] 
# 2.8 tested 
def Select_by_Type(item='EMPTY'):
	bpy.ops.object.select_all(action='DESELECT')
	bpy.ops.object.select_by_type(type=item)
########################################################################## 
# 2.8 tested 
def Select_All():
	import bpy
	objects = bpy.context.scene.objects
	for obj in objects:
		obj.select_set(state=True)
########################################################################## 
def Deselect_All():
	for ob in bpy.context.selected_objects:
		ob.select_set(False)
########################################################################## 
# Work with Name or Object-Reference 
def Select_Object_Any(ref):
	if is_string(ref):
		if Exist_Object(ref):
			bpy.data.objects[ref].select_set(True)
		else:
			return False
	else:
		ref.select_set(True)
########################################################################## 
# Works for Scene or Collection 
def Select_All_Objects(col = None):
	if col == None:
		for co in bpy.context.scene.objects:
			co.select_set(True)
	else:
		col_ref = None
		if is_string(col):
			if Exists_Collection(col):
				col_ref = Get_Collection(col)
			else:
				col_ref = Create_Collection(col)
		else:
			col_ref = col
		for c in col_ref.objects:
			c.select_set(True)
########################################################################## 
# Work with Name or ID 
def Deselect_Object_Any(ref):
	if is_string(ref):
		if Exist_Object(ref):
			bpy.data.objects[ref].select_set(False)
		else:
			return False
	else:
		ref.select_set(False)
	pass
########################################################################## 
def DeSelect_Object(obj):
	obj.select_set(state=False)
#bpy.context.active_object.select_set(state=False) 
#obj.select = False 
########################################################################## 
# Select Similar Objects as Objects in List "i" 
# 
def Select_Similar_SL(i):
	Deselect_All()
	for obj in i:
		Select_Similar_Size_obj(obj,0)
########################################################################## 
# 
def Select_Similar_Active():
	act=Get_Active_Object()
	Deselect_All()
	if act:
		Select_Similar_Size_obj(act,0)
########################################################################## 
# returns a list with active objects 
# 2.8 tested 
# [bpy.data.objects['Sphere'], bpy.data.objects['Sphere.001']] or [] 
def Get_Selected_Objects():
	act=bpy.context.selected_objects
	return act
########################################################################## 
def Get_All_Objects():
	return bpy.data.objects
########################################################################## 
def Get_Current_Scene():
	curr=bpy.context.scene
	return curr
########################################################################## 
def Deselect_all():
	for ob in bpy.context.selected_objects:
		ob.select_set(False)
########################################################################## 
def Delete_Selected_Objects():
	bpy.ops.object.delete()
########################################################################## 
def Delete_Object(ref):
	Inter=Remember_Selected()
	Deselect_all()
	if is_string(ref):
		obj = Get_Object_Any(ref)
		obj.select_set(True)
	else:
		ref.select_set(True)
	delete_selected_objects()
	Restore_Selected(Inter)
########################################################################## 
# Delete List of Objects 
def Delete_Objects(olist):
	Inter=Remember_Selected()
	Deselect_all()
	for ob in olist:
		ob.select_set(True)
	bpy.ops.object.delete()
	Restore_Selected(Inter)
########################################################################## 
# 2.8 tested 
# <bpy_struct, Object("Sphere.001")> 
def Get_Active_Object():
	active=bpy.context.active_object
	return active

########################################################################## 
# Nächstes Objekt das nicht das "Active Objekt" (oba) ist 
def Get_Next_Selected(oba):
	for obj in bpy.context.selected_objects:
		if obj!=oba:
			break
	return obj
########################################################################## 
# 2.8 tested 
# <bpy_struct, Object("Sphere.001")> 
def Get_Last_Object():
#active=obj=bpy.context.selected_objects[0] 
	obj=bpy.context.selected_objects[0]
	return obj
########################################################################## 	 
# Copies 1 Object to a Linked Duplicate 
# 
def Make_Linked_Copy(ref, newname = None, col = None):
	Inter=Remember_Selected()
	Deselect_all()
	Select_Object_Any(ref)
	bpy.ops.object.duplicate_move_linked()
	o = Get_Active_Object()
	if newname is not None:
		o.name = newname
	if col is not None:
		Link_Object_to_Collection(o,col)
	Restore_Selected(Inter)
	return o
########################################################################## 
def Get_Object_Any(ref):
	objref = None
	if ref is None:
		objref = bpy.context.active_object
	else:
		if is_string(ref):
			if Exist_Object(ref):
				objref = bpy.data.objects[ref]
			else:
				objref = bpy.context.active_object
		else :
			objref = ref
	return objref

########################################################################## 
def Get_Active_Material():
	active=bpy.context.scene.node_tree.nodes.active
	return active
########################################################################## 
def Get_Pos_3D_Cursor():
	pos=bpy.context.scene.cursor_location
	return pos
########################################################################## 
def Active_Cam_Point_at_Selected():
	ob=bpy.context.selected_objects[0]
	Active_Cam_Point_at(ob)
########################################################################## 
def Active_Cam_Point_at(obj):
	cam=Get_Active_Cam()
	Point_at(cam,obj,0)
########################################################################## 
# Sample: 
# obg=bpy.context.object 
# pl.append(obg) 
# Point_at(cam,pl[indx], roll=0) 
def Point_at(obj, tar, roll=0):
	target=tar.location
	if not isinstance(target, mathutils.Vector):
		target = mathutils.Vector(target)
	loc = obj.location
# direction points from the object to the target 
	direction = target - loc
	quat = direction.to_track_quat('-Z', 'Y')
# /usr/share/blender/scripts/addons/add_advanced_objects_menu/arrange_on_curve.py 
	quat = quat.to_matrix().to_4x4()
	rollMatrix = mathutils.Matrix.Rotation(m.radians(roll), 4, 'Z')

# remember the current location, since assigning to obj.matrix_world changes it 
	loc = loc.to_tuple()
	obj.matrix_world = quat @ rollMatrix
	obj.location = loc
########################################################################## 
def Make_Point_at_Active():
	obj=Get_Active_Object()
	if obj:
		for oba in bpy.context.selected_objects:
			if obj!=oba:
				Point_at(oba,obj,0)
########################################################################## 
def Make_Point_at():
	oba=bpy.context.selected_objects[0]
	for obj in bpy.context.selected_objects:
		if obj!=oba:
			Point_at(obj,oba,0)
########################################################################## 
def Make_Point_at_A(SE):
	oba=SE[0]
	for obj in bpy.context.selected_objects:
		if obj!=oba:
			Point_at(obj,oba,0)
########################################################################## 
########################################################################## 
# 
# Python specific 
# 
########################################################################## 
########################################################################## 

def Reset_Python(library_name='Library', reload_submodules=True, reimport_after_reset=True):
    import bpy
    import sys
    import console_python
    import importlib
    import gc  # Added for garbage collection to help reduce refcounts if needed

    # Find the console area with added validation
    console_area = None
    for area in bpy.context.screen.areas:
        if area.type == 'CONSOLE':
            console_area = area
            break
    if not console_area:
        print("Warning: No CONSOLE area found. Cannot reset console.")
        return

    # Find the window region within the console area with added validation
    console_region = None
    for region in console_area.regions:
        if region.type == 'WINDOW':
            console_region = region
            break
    if not console_region:
        print("Warning: No WINDOW region found in CONSOLE area. Cannot reset console.")
        return

    # If a console has been used - otherwise the dictionary consoles might not exist
    console_hash = hash(console_region)
    if hasattr(console_python.get_console, 'consoles') and console_hash in console_python.get_console.consoles:
        popped_console = console_python.get_console.consoles.pop(console_hash)
        print(f"Popped console refcount: {sys.getrefcount(popped_console)}")
        # Force garbage collection to potentially release references
        gc.collect()
        print(f"Post-GC refcount for popped console: {sys.getrefcount(popped_console)}")
    else:
        print("Note: No existing console entry to pop for this region.")

    # Prepare context override for operator call
    override = bpy.context.copy()
    override['region'] = console_region
    override['area'] = console_area

    # Clear the console display
    with bpy.context.temp_override(**override):
        bpy.ops.console.clear()

    # Additional reset features: Reload library without changing paths
    try:
        # Collect all related modules (including submodules) for deletion/reload
        related_modules = []
        if library_name in sys.modules:
            related_modules.append(library_name)
        if reload_submodules:
            prefix = library_name + '.'
            related_modules.extend([mod_name for mod_name in list(sys.modules) if mod_name.startswith(prefix)])

        # Delete related modules from sys.modules to force fresh import
        deleted_refcounts = {}
        deleted_modules = {}  # Store module objects for later reference checks
        for mod_name in related_modules:
            if mod_name in sys.modules:
                module = sys.modules[mod_name]
                deleted_modules[mod_name] = module
                deleted_refcounts[mod_name] = sys.getrefcount(module)
                del sys.modules[mod_name]
                # Force GC again to help release any lingering references
                gc.collect()
                print(f"Deleted {mod_name} from sys.modules. Pre-del refcount: {deleted_refcounts[mod_name]}, Post-GC refcount: {sys.getrefcount(module)}")

        if not related_modules:
            print(f"No modules matching {library_name} (or submodules) found in sys.modules; no deletion performed.")

        # Optional: Re-import the library (and its submodules implicitly) if requested
        if reimport_after_reset:
            # Re-import the top-level module, which should pull in submodules as needed
            module = importlib.import_module(library_name)
            # Explicitly reload to ensure any cached state is refreshed (though del should suffice)
            importlib.reload(module)
            # Dynamically import all non-private names into globals() to mimic 'from Library import *'
            for name in dir(module):
                if not name.startswith('_'):
                    globals()[name] = getattr(module, name)
            print(f"Re-imported and reloaded {library_name} with all non-private names into global namespace.")
            # Verify reload by checking if module is back in sys.modules and log additional details
            if library_name in sys.modules:
                print(f"Verification: {library_name} is now reloaded in sys.modules.")
                # Additional feature: Log the module's file path and last modified time for verification
                import os
                import time
                module_file = module.__file__
                if module_file:
                    mod_time = time.ctime(os.path.getmtime(module_file))
                    print(f"Module file: {module_file}, last modified: {mod_time}")
                else:
                    print(f"No __file__ attribute found for {library_name}; it may be a built-in or namespace module.")

            # Additional feature: If submodules were reloaded, verify one as an example
            if reload_submodules and related_modules:
                example_submod = next((m for m in related_modules if '.' in m), None)
                if example_submod:
                    submod = importlib.import_module(example_submod)
                    print(f"Example submodule {example_submod} reloaded successfully.")

    except ImportError as e:
        print(f"Error during re-import: {str(e)}. Ensure the library path is still in sys.path and the module exists.")
    except Exception as e:
        print(f"Error during reset/reload steps: {str(e)}")

    print("Python console reset complete. Namespace cleared, library (and submodules if enabled) reloaded from disk without changing sys.path.")
########################################################################## 
########################################################################## 
# 
# IMAGE to OBJECT 
# 
########################################################################## 
########################################################################## 
# pat="Windows Dateipfad zu einem PNG-Bild". 
############################################################# 
# if mat=1 will also add a color to the cubes which takes more time 
# jo=1 will join all the Objects after the process to a SIngle large Item. 
# hol>0 will make lighter colours above this value to become "holes" (cutout) 
# co=0 use red-value, co=1 use green value, co=2 use blue value, 3 - use all 3 colors 
# siz = 0/1/2 - Ob die Objekte in der Höhe auch eine Kontur bilden 
def Image_to_Objects(pat,mat=1,jo=1,hol=255,co=0,siz=1,met=1):
	now=Start_Timer()
	pat.replace("\\","\\\\")
	print(pat)
	img=bpy.data.images.load(pat, check_existing=True)
	xs=img.size[0]
	ys=img.size[1]
	ar=img.pixels[:]
	y=0
	bpp=Get_Bpp(ar,xs,ys)
	col=NewCollection("PictureCube")
# Achtung Bilder sind y-verkehrt, also unten links ist 0,0 
	z=0
	cnt=0
	alo=list()
	xsc=0.49
	ysc=0.49
	for x in range(xs):
		print("Building "+str(x)+"/"+str(xs))
		for y in range(ys):
			b=Img_get_pixel_rgb(ar,x,y,co,xs,ys,bpp)
			if b<=hol:
				if siz>0:
					sz=(siz-(b/255))*siz
				else:
					sz=1
				psz=1
# We use Metaballs or CUBEs (Metaballs are much faster because they have less data) 
				if met==1:
					bpy.ops.object.metaball_add(type='CUBE',radius=1,enter_editmode=False,align='WORLD',location=(x,y,z),rotation=(0,0,0))
				else:
					bpy.ops.mesh.primitive_cube_add(psz,location=(x,y,z))
				obj=Get_Last_Object()
				cnt+=1
				obj.name="PicCube_"+str(cnt)
				LinkToCollection(col,obj)
# Metaballs only about half the size 
				if met==0:
					fxs=xsc
					fys=ysc
				else:
					fxs=xsc/1.9
					fys=ysc/1.9
# Move Object a bit down so we get a flat bottom 
				obj.scale = (fxs,fys,sz)
				obj.location.z+=sz
				alo.append(obj)
# Decide if we add a material or not 
				if mat==1:
					tri=Img_get_pixel4(ar,x,y,xs,ys,bpp)
					Mat_Create(obj,tri[2],tri[1],tri[0],0,0,1)
#Now we select all the generated Objects 
	for i in alo:
		obj=i
		obj.select_set(state=True)
# If they are Metaballs they need to be converted to MESH first 
	if met==1:
			bpy.ops.object.convert(target='MESH')
# Now we can Join things to a Single Object 
	if jo==1:
		Join_Selected()
# This will display the end time 
	End_Timer(now)
	print("Built:"+str(cnt)+" Objects.")
############################################################# 
def Img_get_pixel(a,x,y,xs,ys,bpp=4):
	lin=xs*bpp
	ind=y*lin+((x)*bpp)
#	print("lin="+str(lin)+"  Ind="+str(ind)) 
	bv=Float_to_C(a[ind])
	gv=Float_to_C(a[ind+1])
	rv=Float_to_C(a[ind+2])
#    print("R:"+hex(rv)+" g:"+hex(gv)+" b:"+hex(bv)) 
	px=rv+gv*256+bv*65536
	return px
############################################################# 
def Img_get_pixel3(a,x,y,xs,ys,bpp=4):
	lin=xs*bpp
	ind=y*lin+((x)*bpp)
#	print("lin="+str(lin)+"  Ind="+str(ind)) 
	bv=Float_to_C(a[ind])
	gv=Float_to_C(a[ind+1])
	rv=Float_to_C(a[ind+2])
#    print("R:"+hex(rv)+" g:"+hex(gv)+" b:"+hex(bv)) 
	px=list()
	px.append(rv)
	px.append(gv)
	px.append(bv)
	return px
############################################################# 
# 
def Img_get_pixel4(a,x,y,xs,ys,bpp=4):
	lin=xs*bpp
	ind=y*lin+((x)*bpp)
#	print("lin="+str(lin)+"  Ind="+str(ind)) 
	bv=a[ind]
	gv=a[ind+1]
	rv=a[ind+2]
#    print("R:"+hex(rv)+" g:"+hex(gv)+" b:"+hex(bv)) 
	px=list()
	px.append(rv)
	px.append(gv)
	px.append(bv)
	return px
############################################################# 
# v=0 - red / 1 - gn / 2- Blue 
def Img_get_pixel_rgb(a,x,y,v,xs,ys,bpp=4):
	lin=xs*bpp
	ind=y*lin+((x)*bpp)
#	print("lin="+str(lin)+"  Ind="+str(ind)) 
	if v==2:
		bv=Float_to_C(a[ind])
	if v==1:
		bv=Float_to_C(a[ind+1])
	if v==3:
		gv=a[ind]+a[ind+1]+a[ind+2]
		ev=gv/3
		bv=Float_to_C(ev)
	else:
		bv=Float_to_C(a[ind+2])
#    print("R:"+hex(rv)+" g:"+hex(gv)+" b:"+hex(bv)) 
	px=bv
	return px
############################################################# 
def Float_to_C(fl):
	res=int(255*fl)
	return res
############################################################# 
def Get_Bpp(a,xs,ys):
	dp=len(a)
	if (dp/(4*xs))==ys:
		bpp=4
	if (dp/(3*xs))==ys:
		bpp=3
	if (dp/(2*xs))==ys:
		bpp=2
	return bpp
############################################################# 	 
############################################################# 
# Interactive Subprogrammes (press Buttons multiple times to change Values) 
# 
############################################################# 
############################################################# 
def Choose_Angle(ang):
	if ang==0:
		ang=12
	elif ang==12:
		ang=30
	elif ang==30:
		ang=45
	elif ang==30:
		ang=45
	elif ang==45:
		ang=90
	else:
		ang=0
	print("Rotiere um "+str(ang)+"Grad.")
	return ang
############################################################# 
def VIC(num,ma=7):
	num+=1
	num=Checknum(num,0,ma)
	return num
############################################################# 
def VDC(num,mi=1):
	num-=1
	num=Checknum(num,mi,1e6)
	return num
############################################################# 
def Checknum(num,mi=1,ma=7):
	if num>ma:
		num=mi
	if num<mi:
		num=ma
	print("Checknum: "+str(num))
	return num

############################################################# 
# Write Text in 3D Viewport 
# 
############################################################# 
#Places a given text in the 3D view 
def TX_Print(print_text):
	bpy.ops.object.text_add(location=(0, 0, 0), rotation=(0, 0, 0))
	bpy.ops.object.editmode_toggle()
	bpy.ops.font.delete()
	bpy.ops.font.text_insert(text=print_text)
	bpy.ops.object.editmode_toggle()
# Stop edit mode 
	if bpy.ops.object.mode_set.poll():
		bpy.ops.object.mode_set(mode='OBJECT')
# delete all mesh objects from a scene 
		bpy.ops.object.select_by_type(type='MESH')
		bpy.ops.object.delete()
# delete all text objects from a scene 
		bpy.ops.object.select_by_type(type='FONT')
		bpy.ops.object.delete()
########################################################################## 
# Add text 
def TX_Add_Text(text="Hallo"):
	if not 'Text' in bpy.data.objects:
		bpy.ops.object.text_add()
		bpy.data.objects['Text'].data.body = text
########################################################################## 
# Text: extrude 
def TX_ExtrudeText(va=0.04):
	bpy.context.object.data.extrude = va
########################################################################## 
# Text: bevel 
def TX_Bevel_Text(bd=0.02,res=8):
	bpy.context.object.data.bevel_depth = bd
	bpy.context.object.data.bevel_resolution = res
########################################################################## 
# Text: transform to a mesh 
# ATTENTION: Characters are not editable any more! 
def TX_conv_to_Mesh(keep=False):
	bpy.ops.object.convert(target='MESH', keep_original=keep)
########################################################################## 
# Delete Objects 
########################################################################## 
# Alles löschen 
def DeleteAll(do=0):
	if do==0:
		bpy.ops.object.select_all(action="SELECT")
		bpy.ops.object.delete(use_global=False)

		for block in bpy.data.cameras:
			if block.users == 0:
				bpy.data.cameras.remove(block)

		for block in bpy.data.meshes:
			if block.users == 0:
				bpy.data.meshes.remove(block)

		for block in bpy.data.materials:
			if block.users == 0:
				bpy.data.materials.remove(block)

		for block in bpy.data.textures:
			if block.users == 0:
				bpy.data.textures.remove(block)

		for block in bpy.data.images:
			if block.users == 0:
				bpy.data.images.remove(block)

		for block in bpy.data.curves:
			if block.users == 0:
				bpy.data.curves.remove(block)

		for block in bpy.data.lights:
			if block.users == 0:
				bpy.data.lights.remove(block)

	else:
		DeleteAll(0)
		context = bpy.context
		scene = context.scene

		for c in scene.collection.children:
			scene.collection.children.unlink(c)
			bpy.data.collections.remove(c)


		for c in bpy.data.collections:
			if not c.users:
				bpy.data.collections.remove(c)

########################################################################## 
def Delete_Selected():
	bpy.ops.object.delete()
########################################################################## 
def Delete_Object_by_name(name):
# Select the object 
	bpy.data.objects[name].select = True
	bpy.ops.object.delete()
########################################################################## 
def Delete_Object_by_ID(id):
# Select the object 
	bpy.data.objects[id.name].select = True
	bpy.ops.object.delete()


########################################################################## 
########################################################################## 
# Set Clipping and Camera Lock 
# 
########################################################################## 
########################################################################## 
def View3d_SetClipEnd(e=1e6):
#=== Iterates through the blender GUI's windows, screens, areas, regions to find the View3D space and its associated window.  Populate an 'oContextOverride context' that can be used with bpy.ops that require to be used from within a View3D (like most addon code that runs of View3D panels) 
# Tip: If your operator fails the log will show an "PyContext: 'xyz' not found".  To fix stuff 'xyz' into the override context and try again! 
###IMPROVE: Find way to avoid doing four levels of traversals at every request!! 
###LEARN: Frequently, bpy.ops operators are called from View3d's toolbox or property panel.  By finding that window/screen/area we can fool operators in thinking they were called from the View3D! 
	for oWindow in bpy.context.window_manager.windows:
		oScreen = oWindow.screen
		for oArea in oScreen.areas:
			if oArea.type == 'VIEW_3D':
				v3d_area = oArea
		space_data = v3d_area.spaces.active
		space_data.clip_end=e
########################################################################## 
def View3d_Lock_Camera(ei=True,al=True):
#=== Iterates through the blender GUI's windows, screens, areas, regions to find the View3D space and its associated window.  Populate an 'oContextOverride context' that can be used with bpy.ops that require to be used from within a View3D (like most addon code that runs of View3D panels) 
# Tip: If your operator fails the log will show an "PyContext: 'xyz' not found".  To fix stuff 'xyz' into the override context and try again! 
	for oWindow in bpy.context.window_manager.windows:
		oScreen = oWindow.screen
		for oArea in oScreen.areas:
			if oArea.type == 'VIEW_3D':
				v3d_area = oArea
		space_data = v3d_area.spaces.active
		space_data.lock_camera = ei
		break
	if al==True:
		Set_Camera_to_View()

############################################################################ 
#Context:('VIEW_3D', 'IMAGE_EDITOR', 'NODE_EDITOR', 'SEQUENCE_EDITOR', 'CLIP_EDITOR', 'DOPESHEET_EDITOR', 'GRAPH_EDITOR', 'NLA_EDITOR', 'TEXT_EDITOR', 'CONSOLE', 'INFO', 'TOPBAR', 'STATUSBAR', 'OUTLINER', 'PROPERTIES', 'FILE_BROWSER', 'PREFERENCES') 
def Get_Override(view='VIEW_3D'):
	for oWindow in bpy.context.window_manager.windows:
		oScreen = oWindow.screen
		for oArea in oScreen.areas:
			if oArea.type == view:
				override = bpy.context.copy()
				override['area'] = oArea
				break
	return override
############################################################################ 
# bpy.ops.view3d.camera_to_view(override) 
def Get_Override_View3D():
	for area in bpy.context.screen.areas:
		if area.type == 'VIEW_3D':
			override = bpy.context.copy()
# PERSP, ORTHO, CAMERA 
#area.spaces.active.region_3d.view_perspective = 'CAMERA' 
			override['area'] = area
			break
	return override
############################################################################ 
def Set_Camera_to_View():
#  area.spaces.active.region_3d.view_perspective = Cam # Cam='CAMERA' 
	override=Get_Override_View3D()
	bpy.ops.view3d.camera_to_view(override)
############################################################################ 
def Set_Camera_to_Selected():
	override=Get_Override_View3D()
	bpy.ops.view3d.camera_to_view_selected(override)
############################################################################ 
def Center_Camera_View_All():
	override=Get_Override_View3D()
	bpy.ops.view3d.view_all(override,center=True)
############################################################################ 
# bpy.ops.view3d.viewnumpad(context, 'EXEC_DEFAULT', type='TOP') 
# bpy.ops.view3d.view_persportho(context, 'EXEC_DEFAULT') 
# Context:('VIEW_3D', 'IMAGE_EDITOR', 'NODE_EDITOR', 'SEQUENCE_EDITOR', 'CLIP_EDITOR', 'DOPESHEET_EDITOR', 'GRAPH_EDITOR', 'NLA_EDITOR', 'TEXT_EDITOR', 'CONSOLE', 'INFO', 'TOPBAR', 'STATUSBAR', 'OUTLINER', 'PROPERTIES', 'FILE_BROWSER', 'PREFERENCES') 
def Get_Context(Con="VIEW_3D"):
	for area in bpy.context.screen.areas:
		if area.type == Con:
			break

	for region in area.regions:
		if region.type == "WINDOW":
			break

	space = area.spaces[0]

	context = bpy.context.copy()
	context['area'] = area
	context['region'] = region
	context['space_data'] = space
	return context
############################################################################ 
# 0 - Point View, 1 - Point Cam 
# al - 0/1 - if 1 all 3D-Views will be iterated 
def Point_View_Cam_at_Selected(ei=0,al=0):
	for area in bpy.context.screen.areas:
		if area.type == 'VIEW_3D':
			ctx = bpy.context.copy()
			ctx['area'] = area
			ctx['region'] = area.regions[-1]
			if all==0:
				break
	if ei==0:
# points view 
		bpy.ops.view3d.view_selected(ctx)
	else:
# points camera 
		bpy.ops.view3d.camera_to_view_selected(ctx)
	return ctx

########################################################################## 
def Switch_LIF():
	if LIF:
		LIF=1-LIF
	else:
		LIF=0
	print(str(LIF))
########################################################################## 
########################################################################## 
# 
#  PARTICLE-SYSTEM 
########################################################################## 
########################################################################## 
def Add_Particles_to_Selected():
	inter=Remember_Selected()
	Deselect_All()
	for i in inter:
		obj=i
		Set_Active_Object(obj)
		Add_Particles_to_Active()
	Restore_Selected(inter)
########################################################################## 
def Add_Particles_to_Object(obj):
	inter=Remember_Selected()
	Set_Active_Object(obj)
	ps=Add_Particles_to_Active()
	Restore_Selected(inter)
	return ps
########################################################################## 
# https://wiki.blender.jp/Dev:Py/Scripts/Cookbook/Code_snippets/Simulations 
def Add_Particles_to_Active(name="PaSy"):
	emitter = bpy.context.object
	pl=len(object.particle_systems)
	if pl == 0:
		bpy.ops.object.particle_system_add()
		ps = emitter.particle_systems[-1]
		ps.name = name
	else:
		ps=emitter.particle_systems[-1]
	ps.count=99
	ps.frame_start = 1
	ps.frame_end = GetLastFrame()
	ps.lifetime = 50
	ps.lifetime_random = 0.4
	ps.emit_from = 'FACE'
	ps.use_render_emitter = True
	ps.object_align_factor = (0,0,1)
	ps.physics_type = 'NEWTON'
	ps.mass = 2.5
	ps.particle_size = 0.3
	ps.use_multiply_size_mass = True
	ew = ps.effector_weights
	ew.gravity = 1.0
	ew.wind = 1.0
	ps.child_nbr = 10
	ps.rendered_child_count = 10
	ps.child_type = 'SIMPLE'
	ps.draw_percentage = 100
	ps.draw_method = 'CROSS'
	#ps.material = 1
	ps.particle_size = 0.1
	ps.render_type = 'HALO'
	ps.render_step = 3
	return ps
########################################################################## 
########################################################################## 
# Texteditor 
########################################################################## 
########################################################################## 
def Texteditor_Set_Line(txt,ac='Text.001'):
	t = bpy.data.texts[ac]
	line=t.lines[0]
	line.body=txt
########################################################################## 
#for line in t.lines: 	#	line.body = "" 
def Texteditor_Set(ac='Text.001'):
	Texteditor_Clear(ac)
	t = bpy.data.texts[ac]
	txt="from Library import *\no=Get_Outliner_Override()\nv=Get_Override('VIEW_3D')\nobj = Get_Active_Object()\nGA=Remember_Selected()\n"
	t.write(txt)
########################################################################## 
def Texteditor_Clear(ac='Text.001'):
	bpy.data.texts[ac].clear()
########################################################################## 
########################################################################## 
# Do with Collections / OUTLINER 
########################################################################## 
########################################################################## 
def Get_Outliner_Context():
	for oWindow in bpy.context.window_manager.windows:
		oScreen = oWindow.screen
		for oArea in oScreen.areas:
			if oArea.type == 'OUTLINER':
				break
	return oArea
########################################################################## 
def Get_Outliner_Override():
	for oWindow in bpy.context.window_manager.windows:
		oScreen = oWindow.screen
		for oArea in oScreen.areas:
			if oArea.type == 'OUTLINER':
				override = bpy.context.copy()
				override['area'] = oArea
				oc=override
				break
	return oc
########################################################################## 	 
# Set Filter for Rendering in the Outliner 
def Outliner_Set_Render_Selected(disable=True):
    """Set render visibility for selected collections in the Outliner.
    
    Args:
        disable (bool): True to disable rendering, False to enable.
    """
    # Find selected collections in the Outliner
    selected_collections = []
    for collection in bpy.data.collections:
        if collection.is_evaluated and collection.name in bpy.context.view_layer.layer_collection.children:
            layer_coll = bpy.context.view_layer.layer_collection.children[collection.name]
            if layer_coll.is_selected:
                selected_collections.append(collection)
    
    if not selected_collections:
        print("Warning: No collections selected in the Outliner.")
        return

    # Set render visibility
    for collection in selected_collections:
        collection.hide_render = disable
        print(f"{'Disabled' if disable else 'Enabled'} render for collection: {collection.name}")

    # Redraw Outliner if needed
    for area in bpy.context.screen.areas:
        if area.type == 'OUTLINER':
            area.tag_redraw()
            break
########################################################################## 	 
# 1-Show /0 - Hide 
def Outliner_Set_Render_All(disable=True):
    """Set render visibility for all collections in the scene."""
    for collection in bpy.data.collections:
        collection.hide_render = disable
    for area in bpy.context.screen.areas:
        if area.type == 'OUTLINER':
            area.tag_redraw()
            break
########################################################################## 	 
def Outliner_Deactivate_Selected(ac=0):
	a=Get_Outliner_Override()
	if ac==0:
		bpy.ops.outliner.collection_exclude_set(a)
	else:
		bpy.ops.outliner.collection_exclude_clear(a)
########################################################################## 
# 1-Show /0 - Hide 
def Outliner_Deactivate_All(ac=0):
	inter=Remember_Selected()
	Outliner_Select_all("SELECT")
	Outliner_Deactivate_Selected(ac)
	Restore_Selected(inter)

########################################################################## 	 
#TOGGLE Toggle, Toggle selection for all elements. 
#SELECT Select, Select all elements. 
#DESELECT Deselect, Deselect all elements. 
#INVERT Invert, Invert selection of all elements 
def Outliner_Select_all(ac='TOGGLE'):
	a=Get_Outliner_Override()
	bpy.ops.outliner.select_all(a,action=ac)
	Set_Redraw()
########################################################################## 
def Outliner_Show_Active():
	a=Get_Outliner_Override()
	bpy.ops.outliner.show_active(a)
	Set_Redraw()
########################################################################## 
# Open all object entries and close all others. 
# Seems to work sometimes - Redraw appears dangerouse! 
def Outliner_Show_Hierarchy():
	a=Get_Outliner_Override()
	bpy.ops.outliner.show_hierarchy(a)
	#Set_Redraw()
########################################################################## 
# 1-Show /0 - Hide 
def Outliner_UnHide_All(ac=1):
	inter=Remember_Selected()
	Outliner_Select_all("SELECT")
	Outliner_UnHide_Selected(ac)
	Restore_Selected(inter)
########################################################################## 
# 1-Show /0 - Hide 
def Outliner_UnHide_Selected(ac=1):
	a=Get_Outliner_Override()
	if ac==1:
		bpy.ops.outliner.unhide_all(a)
	else:
		bpy.ops.outliner.hide(a)
########################################################################## 
# ATTENTION: Calling this twice may KILL BLENDER! 
def Set_Redraw():
	bpy.ops.wm.redraw_timer(type='DRAW_WIN', iterations=1)
########################################################################## 
#open (True/False (optional)) – Open, Expand all entries one level deep 
def Outliner_Show_One_Level():
	a=Get_Outliner_Override()
	bpy.ops.outliner.show_one_level(a)
	Set_Redraw()
########################################################################## 
# 2 - Collapse ALL Collections 
# 1 - Expand lower collections 
# 0 - Expand all Collections 
# 3 - Expand ALL 
def Collapse_Outliner(state):
###IMPROVE: Find way to avoid doing four levels of traversals at every request!! 
###LEARN: Frequently, bpy.ops operators are called from View3d's toolbox or property panel. 
#By finding that window/screen/area we can fool operators in thinking they were called from the View3D! 
	oArea=Get_Outliner_Context()
	bpy.ops.outliner.show_hierarchy({'area': oArea}, 'INVOKE_DEFAULT')
	for i in range(state):
		bpy.ops.outliner.expanded_toggle({'area': oArea})
	oArea.tag_redraw()
########################################################################## 
#Hide all Selections but the selected one, if ca=True only the selected Collections will be hidden. 
def Outliner_Isolate_Selected(ca=False):
	a=Get_Outliner_Override()
	bpy.ops.outliner.collection_isolate(a,extend=ca)
########################################################################## 
# Test if an Object is a duplicate linked or not 
# returns t/f 
# res=Is_Obj_linked(obj) 
# 
def Is_Obj_linked(ob):
	myo = bpy.data.objects[ob.name]
	re=myo.data.name
	rf=myo.name
	if re == rf:
		b = False
	else:
		b = True
	return b
########################################################################## 
def Make_Linked(obx,lnk=0):
	myo=obx.copy()
	Link_Obj_to_Scene(myo)
	if lnk==1:
		Convert_Linked_to_Real_Object(myo)
		#myo.make_single_user(object=True, obdata=True, material=True, animation=False)
	return myo
########################################################################## 
def Convert_Dup_Linked_to_Real(a=False):
	bpy.ops.object.make_single_user(object=True, obdata=True, material=True, animation=a)
########################################################################## 
# Convertiert explizit "obj" und verändert Selection nicht 
def Convert_Linked_to_Real_Object(obj):
	if Is_Obj_linked(obj)==True:
		rem=Remember_Selected()
		bpy.ops.object.make_single_user(type='SELECTED_OBJECTS',object=False,obdata=True, material=True, animation=False)
		Restore_Selected(rem)

########################################################################## 

########################################################################## 
# TIMER and File Ops 
########################################################################## 
# Wert muss an End_TImer übergeben werden 
def Start_Timer():
	now = time.time()
	return now
########################################################################## 
def End_Timer(then):
	now = time.time() #Time after it finished
	used=now-then
	print("It took: ",used, " seconds")
########################################################################## 
def SaveFile():
	bpy.ops.wm.save_as_mainfile(filepath=bpy.data.filepath)
########################################################################## 

########################################################################## 
########################################################################## 
# RigidBody and Softbody 
# Currently Softbody Bake needs taht there is at least one RB-Object 
# in the Scene. For example Make the FLoor a passive RB-Object 
########################################################################## 
# Returns 0 or 1 ifObject is Rigid-Body Object 
def Is_RigidBody(ref):
	if ref.rigid_body is None:
		a=0
	else:
		a=1
	return a
########################################################################## 
# Test if RB is enabled and available 
# 
def Exist_Rigid_Body():
	if bpy.context.object.rigid_body is None:
		res=0
	else:
		res=1
	return res
############################################################# 
def ChooseBB(num):
	res=Get_BB_by_Num(num)
	print("Choosen RB-BB is: "+res)
	return res
############################################################# 
def Get_BB_by_Num(val=2):
	BB={
		1:'SPHERE',
		2:'BOX',
		3:'CONE',
		4:'CAPSULE',
		5:'MESH',
		6:'CONVEX_HULL',
		7:'CYLINDER'
		}
	res=BB.get(val,'BOX')
	return res
############################################################# 	 
def RB_Delete_Bakes():
	if Exist_Rigid_Body()==1:
		bpy.ops.ptcache.free_bake_all()
########################################################################## 
def RB_Copy_from_Active():
	bpy.ops.rigidbody.object_settings_copy()
########################################################################## 
# Zum Beispiel 240,80 
def RB_SetCalculation(Steps,Solver):
	bpy.context.scene.rigidbody_world.steps_per_second = Steps
	bpy.context.scene.rigidbody_world.solver_iterations = Solver
########################################################################## 
def RB_Copy_from_Active_and_Bake():
	RB_Copy_from_Active()
	RB_Bakeonly()
########################################################################## 
def RB_Bake_Clothes():
	bpy.ops.ptcache.free_bake_all()
	bpy.ops.ptcache.bake_all(bake=True)
########################################################################## 
def Save_and_Bake():
	SaveFile()
	RB_Bakeonly()
########################################################################## 
# #scene.rigidbody_set_frame_start=enf 
def RB_Set_Start_End_Frame(st=1,en=250):
	bpy.context.scene.rigidbody_world.point_cache.frame_start=st
	bpy.context.scene.rigidbody_world.point_cache.frame_end =en
########################################################################## 
def SB_Set_Start_End_Frame(st=1,en=250,step=1):
	bpy.context.object.modifiers["Softbody"].point_cache.frame_start = st
	bpy.context.object.modifiers["Softbody"].point_cache.frame_end = en
	bpy.context.object.modifiers["Softbody"].point_cache.frame_step = step
########################################################################## 
def Ani_Start_Frame(val = None):
	if val is None:
		return GS().frame_start
	else:
		GS().frame_start = val
########################################################################## 
def Ani_End_Frame(val = None):
	if val is None:
		return GS().frame_end
	else:
		GS().frame_end = val
########################################################################## 
def Ani_Set_Frames(start = None, end = None):
	res=[]
	if start is None:
		res.append(Ani_Start_Frame())
		res.append(Ani_End_Frame())
	else:
		Ani_Start_Frame(start)
		Ani_End_Frame(end)
	return res
########################################################################## 
def Ani_Set_Step(val):
	get_scene().frame_step = val
########################################################################## 
def Ani_Set_Start_End_Frame(st=1,en=250):
	bpy.context.scene.frame_end=en
	bpy.context.scene.frame_start=st
########################################################################## 
def Set_Start_End_Frames(st=1,en=250):
	Ani_Set_Start_End_Frame(st,en)
	RB_Set_Start_End_Frame(st,en)

########################################################################## 
def RB_Synchron_Frames():
	en=bpy.context.scene.frame_end
	st=bpy.context.scene.frame_start
	RB_Set_Start_End_Frame(st,en)
########################################################################## 
def SB_Synchron_Frames():
	en=bpy.context.scene.frame_end
	st=bpy.context.scene.frame_start
	SB_Set_Start_End_Frame(st,en)
########################################################################## 
def RB_Bakeonly(step=1):
    """Bake rigid body simulation to keyframes for the current scene's frame range.
    
    Args:
        step (int): Frame step for baking (default: 1).
    """
    tm = Start_Timer()
    print("Starting rigid body bake...")

    # Check for rigid body world
    if bpy.context.scene.rigidbody_world is None:
        print("Error: No rigid body world found. Please set up a rigid body simulation.")
        End_Timer(tm)
        return

    # Check for rigid body objects
    rb_objects = [obj for obj in bpy.context.scene.objects if obj.rigid_body is not None]
    if not rb_objects:
        print("Error: No rigid body objects found in the scene.")
        End_Timer(tm)
        return

    # Use scene frame range for baking
    frame_start = bpy.context.scene.frame_start
    frame_end = bpy.context.scene.frame_end

    try:
        # Free existing bakes (if any)
        bpy.ops.ptcache.free_bake_all()
        # Bake to keyframes
        bpy.ops.rigidbody.bake_to_keyframes(frame_start=frame_start, frame_end=frame_end, step=step)
        print("Rigid body bake completed successfully.")
    except Exception as e:
        print(f"Error during rigid body bake: {str(e)}")
    finally:
        End_Timer(tm)
########################################################################## 
def RB_Bake(Steps,Solver):
	tm=Start_Timer()
	print("Started with RB-BAKE: "+str(Steps)+"/"+str(Solver))
	bpy.ops.ptcache.free_bake_all()
	RB_SetCalculation(Steps,Solver)
	bpy.ops.ptcache.bake_all(bake=True)
	print("RB-BAKE Done")
	End_Timer(tm)
########################################################################## 
# Add selected Object to Rigidbody World 
# type='ACTIVE' bbox='MESH','CONVEX_HULL' 
def AddRigidBody(type,bbox,ac=0):
	bpy.ops.rigidbody.object_add()
	bpy.context.object.rigid_body.type = type
	bpy.context.object.rigid_body.restitution = 0.2
	bpy.context.object.rigid_body.friction = 0.111354
	bpy.context.object.rigid_body.collision_shape = bbox
	bpy.ops.rigidbody.mass_calculate(material='Brick (Common)', density=1.0)
	RB_Deactivate(ac)
########################################################################## 
def RB_Remove():
	bpy.ops.rigidbody.objects_remove()
########################################################################## 
#Reset Rigid Body World 
def RB_Reset():
	bpy.ops.rigidbody.world_remove()
	bpy.ops.rigidbody.world_add()
########################################################################## 
# RB Bake rigid body transformations of selected objects to keyframes 
#bpy.ops.rigidbody.bake_to_keyframes(frame_start=1, frame_end=250, step=1) 
# step (int in [1, 120], (optional)) – Frame Step 
def RB_Bake_to_Frames():
	bpy.ops.rigidbody.bake_to_keyframes()
########################################################################## 
# bpy.ops.rigidbody.connect(con_type='FIXED', pivot_type='CENTER', connection_pattern='SELECTED_TO_ACTIVE') 
# See: https://docs.blender.org/api/current/bpy.ops.rigidbody.html 
########################################################################## 
def RB_Remove_Constraint():
	bpy.ops.rigidbody.constraint_remove()
########################################################################## 
def GetFirstFrame():
	scn = bpy.context.scene
	frame_start=scn.frame_start
	return frame_start
########################################################################## 
def GetLastFrame():
	scn = bpy.context.scene
	frame_end=scn.frame_end
	return frame_end
########################################################################## 
def RB_Add_Dynamic():
	RB_Set_Dynamic(True)
########################################################################## 
def RB_Remove_Dynamic():
	RB_Set_Dynamic(False)
########################################################################## 
def RB_Add_Kinematic():
	RB_Set_Kinematic(True)
########################################################################## 
def RB_Remove_Kinematic():
	RB_Set_Kinematic(False)
########################################################################## 
def RB_Set_Dynamic(t=True):
	for obj in bpy.context.selected_objects:
		a=Is_RigidBody(obj)
		if a==1:
			obj.rigid_body.enabled = t
########################################################################## 
# kf - Nummert des Keyframes 
def RB_Set_Kinematic_at_KF(t=True,kf=1):
	for obj in bpy.context.selected_objects:
		RB_Set_Kinematic_obj_at_KF(obj,t,kf)
#	bpy.context.active_object.keyframe_insert(data_path="rigid_body.kinematic",frame=kf) 
########################################################################## 
# oba - Object ID or Object name 
# kf - Nummer des Keyframes 
def RB_Set_Kinematic_obj_at_KF(oba,t=True,kf=1):
	obj=Get_Object_Any(oba)
	obj.rigid_body.kinematic = t
	obj.keyframe_insert(data_path="rigid_body.kinematic",frame=kf)
########################################################################## 
# obj - Object ID or Object name 
# kf - Nummer des Keyframes 
def RB_Set_Dynamic_obj_at_KF(oba,t=True,kf=1):
	obj=Get_Object_Any(oba)
	a=Is_RigidBody(obj)
	if a==1:
		obj.rigid_body.enabled = t
		obj.keyframe_insert(data_path="rigid_body.enabled",frame=kf)
########################################################################## 
def RB_Set_Kinematic(t=True):
	for obj in bpy.context.selected_objects:
		obj.rigid_body.kinematic = t
########################################################################## 
def RB_Set_Dynamic_at_KF(t=True,kf=1):
	for obj in bpy.context.selected_objects:
		a=Is_RigidBody(obj)
		if a==1:
			RB_Set_Dynamic_obj_at_KF(obj,t,kf)
########################################################################## 		 
def RB_Set_Dynamic_for_A_at_KF(i,t=True,kf=1):
	for obj in i:
		a=Is_RigidBody(obj)
		if a==1:
			RB_Set_Dynamic_obj_at_KF(obj,t,kf)
########################################################################## 
def RB_Set_Dynamic_at_actual_KF(t=True):
	kf=Get_Actual_KF()
	RB_Set_Dynamic_at_KF(t,kf)
########################################################################## 	 
def RB_Set_Dynamic_for_A_at_actual_KF(CA,t=True):
	kf=Get_Actual_KF()
	RB_Set_Dynamic_for_A_at_KF(CA,t,kf)
########################################################################## 
def RB_Set_Kinematic_at_actual_KF(t=True):
	kf=Get_Actual_KF()
	RB_Set_Kinematic_at_KF(t,kf)
########################################################################## 
# Make Object invisible, deactivate RB from Frame A to Frame B 
# [INP1] - Pa 
# [INP2] - Pb 
def BulletKFA(Pa,Pb):
	RB_RigidBodyAdd_Intelligent()
	Ani_View_Selected_Objects_at_KF(False,Pa,1)
	RB_Set_Dynamic_at_KF(False,Pb)
	RB_Set_Kinematic_at_KF(True,Pb)
	RB_Set_Dynamic_at_KF(True,Pa)
	RB_Set_Kinematic_at_KF(False,Pa)
	Ani_View_Selected_Objects_at_KF(True,Pb,1)
	cprint("Ready")
########################################################################## 
#	Make object Visible from Frame A to Frame B incl.RB Active 
# [INP1] - Pa 
# [INP2] - Pb 
def BulletKFB(Pa,Pb):
	# Enable Dynamic next KF
	Pc=Pa+1
	RB_RigidBodyAdd_Intelligent()
	Ani_View_Selected_Objects_at_KF(False,Pa,1)
	Ani_View_Selected_Objects_at_KF(True,Pb,1)
	RB_Set_Dynamic_at_KF(True,Pc)
	RB_Set_Dynamic_at_KF(False,Pb)
	RB_Set_Kinematic_at_KF(False,Pc)
	RB_Set_Kinematic_at_KF(True,Pb)
########################################################################## 
# Make Object invisible, deactivate RB from Frame A to Frame B 
# [INP1] - Pa 
# [INP2] - Pb 
# KFA fails often, so i do it 2 times. 
def BulletKFA2(Pa,Pb):
	GX=Remember_Selected()
	BulletKFA(Pa,Pb)
	Deselect_All()
	Restore_Selected(GX)
	BulletKFA(Pa,Pb)
	cprint("Ready")
########################################################################## 
#	Make object Visible from Frame A to Frame B incl.RB Active 
# [INP1] - Pa 
# [INP2] - Pb 
# KFB fails often, so i do it 2 times. 
def BulletKFB2(Pa,Pb):
	GX=Remember_Selected()
	BulletKFB(Pa,Pb)
	Deselect_All()
	Restore_Selected(GX)
	BulletKFB(Pa,Pb)
	cprint("Ready")
########################################################################## 
#	Make object Visible from Frame A to Frame B incl.RB InActive 
# [INP1] - Pa 
# [INP2] - Pb 
def BulletKFC(Pa,Pb):
	RB_RigidBodyAdd_Intelligent()
	Ani_View_Selected_Objects_at_KF(False,Pa)
	RB_Set_Dynamic_at_KF(False,Pb)
	RB_Set_Dynamic_at_KF(False,Pa)
	Ani_View_Selected_Objects_at_KF(True,Pb)
	cprint("Ready")
########################################################################## 
#	Make object Visible from Frame A to Frame B incl.RB InActive 
# [INP1] - Pa 
# [INP2] - Pb 
# KFC fails often, so i do it 2 times. 
def BulletKFC2(Pa,Pb):
	GX=Remember_Selected()
	BulletKFC(Pa,Pb)
	Deselect_All()
	Restore_Selected(GX)
	BulletKFC(Pa,Pb)
	cprint("Ready")
########################################################################## 
#	Make object Visible in Render from Frame A to Frame B incl.RB Active, keep visible in Viewport 
# [INP1] - Pa 
# [INP2] - Pb 
def BulletKFD(Pa,Pb):
	# Enable Dynamic next KF
	Pc=Pa+1
	RB_RigidBodyAdd_Intelligent()
	Ani_View_Selected_Objects_at_KF(False,Pa)
	Ani_View_Selected_Objects_at_KF(True,Pb)
	RB_Set_Dynamic_at_KF(True,Pc)
	RB_Set_Dynamic_at_KF(False,Pb)
########################################################################## 
# ta=0 bei Start_KF, und ta=1 bei Ziel_KF 
# fr - Framnumber 
# oba - object ID or name 
def RB_Set_KinDyn_Object(oba,fr,ta=0):
	obj=Get_Object_Any(oba)
	if ta==0:
		Ki=True
		Dy=True
	else:
		Ki=False
		Dy=True
	RB_Set_Kinematic_obj_at_KF(obj,Ki,fr)
	a=Is_RigidBody(obj)
	if a==0:
		RB_Set_Dynamic_obj_at_KF(obj,Dy,fr)
########################################################################## 
# ta=0 bei Start_KF, und 1 bei Ziel_KF 
def RB_Set_KinDyn(fr,ta=0):
	if ta==0:
		Ki=True
		Dy=True
	else:
		Ki=False
		Dy=True
	RB_Set_Kinematic_at_KF(Ki,fr)
	RB_Set_Dynamic_at_KF(Dy,fr)
########################################################################## 
def RB_Deactivate(pa=1):
	if pa==1:
		val=True
	else:
		val=False
	bpy.context.object.rigid_body.use_deactivation = val
	bpy.context.object.rigid_body.use_start_deactivated = val
	##########################################################################
def RB_Get_BB_Type(typ='B'):
	if typ=='B':
		typ='BOX'
	elif typ=='S':
		typ='SPHERE'
	elif typ=='C':
		typ='CONVEX_HULL'
	elif typ=='K':
		typ='CAPSULE'
	elif typ=='O':
		typ='CONE'
	elif typ=='Y':
		typ='CYLINDER'
	elif typ=='M':
		typ='MESH'
	else:
		typ='MESH'
	return typ
########################################################################## 
def RB_Get_BB_by_Name(obj):
	nam=obj.name
	if "Plane" in nam:
		typ='BOX'
	elif "Cube" in nam:
		typ='BOX'
	elif "Sphere" in nam:
		typ='SPHERE'
	elif "Cylinder" in nam:
		typ='CYLINDER'
	elif "Cone" in nam:
		typ='CONE'
	elif "Torus" in nam:
		typ='CONVEX_HULL'
	elif "Icosphere"  in nam:
		typ='SPHERE'
	elif "GD_mesh" in nam:
		typ='CONVEX_HULL'
	else:
		typ='MESH'
	return typ
########################################################################## 
def RB_Get_Sort_by_Name(obj):
	nam=obj.name
	if "Plane" in nam:
		sort='PASSIVE'
	else:
		sort='ACTIVE'
	return sort

########################################################################## 
def RB_Add_Single_Object(obj):
	if Exist_Object(obj)==False:
		return
	a=Is_RigidBody(obj)
	if a==0:
		rem=Remember_Selected()
		Deselect_All()
		Set_Active_Object(obj)
		obj.select_set(state=True)
		typ=RB_Get_BB_by_Name(obj)
		sort=RB_Get_Sort_by_Name(obj)
		AddRigidBody(sort,typ)
		RB_Set_RND_Mass(obj,10,500)
		Restore_Selected(rem)
########################################################################## 
# Will try to get the proper Bounding-Box 
def RB_RigidBodyAdd_Intelligent():
	inter=Remember_Selected()
	alo=list()
	for obj in bpy.context.selected_objects:
		alo.append(obj)
	Deselect_All()
	for i in alo:
		obj=i
		a=Is_RigidBody(obj)
		if a==0:
			RB_Add_Single_Object(obj)
	Restore_Selected(inter)
########################################################################## 
def RB_RigidBodyAdd_Selected(ap='A',typ='B'):
	if (ap=='A'):
		sort='ACTIVE'
	else:
		sort='PASSIVE'
	typ=RB_Get_BB_Type(typ)
	AddRigidBody(sort,typ)
########################################################################## 
# pa=1 add as ACTIVE 
# pa=0 add as PASSIVE 
def RB_AddSelectedObjects(is_active=True, min_mass=50, max_mass=250):
    """Add rigid body properties to selected objects.
    
    Args:
        is_active (bool): True for active rigid bodies, False for passive.
        min_mass (float): Minimum random mass for rigid bodies.
        max_mass (float): Maximum random mass for rigid bodies.
    """
    import random as r
    from . import Start_Timer, End_Timer, Remember_Selected, Restore_Selected, Is_RigidBody, RB_Set_RND_Mass

    tm = Start_Timer()
    print("Adding rigid body properties to selected objects...")

    # Check for rigid body world; create if missing
    if bpy.context.scene.rigidbody_world is None:
        bpy.ops.rigidbody.world_add()
        print("Created new rigid body world.")

    # Store selected objects and active object
    saved_selection = Remember_Selected()
    if not saved_selection[1:]:  # Skip active object at index 0
        print("Error: No objects selected.")
        End_Timer(tm)
        return

    # Find Outliner area for context override
    outliner_area = None
    for area in bpy.context.screen.areas:
        if area.type == 'OUTLINER':
            outliner_area = area
            break

    # Process each object
    rb_type = 'ACTIVE' if is_active else 'PASSIVE'
    failed_objects = []
    for obj in saved_selection[1:]:  # Skip active object at index 0
        if obj.type not in {'MESH', 'EMPTY'}:  # Rigid bodies typically apply to meshes
            failed_objects.append(obj.name)
            continue
        if Is_RigidBody(obj):
            continue  # Skip objects already with rigid body

        # Set object as active and selected for operator
        bpy.context.view_layer.objects.active = obj
        obj.select_set(True)

        try:
            with bpy.context.temp_override(area=outliner_area) if outliner_area else contextlib.nullcontext():
                bpy.ops.rigidbody.object_add()
                obj.rigid_body.type = rb_type
                obj.rigid_body.restitution = 0.2  # Match original defaults
                obj.rigid_body.friction = 0.111354
                RB_Set_RND_Mass(obj, min_mass, max_mass)
        except Exception as e:
            print(f"Error adding rigid body to {obj.name}: {str(e)}")
            failed_objects.append(obj.name)
        finally:
            obj.select_set(False)  # Deselect after processing

    # Copy settings from first processed object to others (if needed)
    if saved_selection[1:] and not Is_RigidBody(saved_selection[1]):
        first_rb_obj = next((obj for obj in saved_selection[1:] if Is_RigidBody(obj)), None)
        if first_rb_obj:
            for obj in saved_selection[1:]:
                if obj != first_rb_obj and Is_RigidBody(obj):
                    obj.select_set(True)
                    bpy.context.view_layer.objects.active = first_rb_obj
                    try:
                        with bpy.context.temp_override(area=outliner_area) if outliner_area else contextlib.nullcontext():
                            bpy.ops.rigidbody.object_settings_copy()
                    except Exception as e:
                        print(f"Error copying rigid body settings to {obj.name}: {str(e)}")
                    obj.select_set(False)

    # Restore original selection
    Restore_Selected(saved_selection)

    # Report results
    if failed_objects:
        print(f"Failed to add rigid body to: {', '.join(failed_objects)}")
    print(f"Rigid body properties added to {len(saved_selection[1:]) - len(failed_objects)} objects.")
    End_Timer(tm)
    
########################################################################## 
def RB_Add_Object(obj,pa=1,val='ACTIVE'):
	a=Is_RigidBody(obj)
	if a==0:
		inter=Remember_Selected()
		Set_Active_Object(obj)
		obj.select_set(state=True)
		bpy.ops.rigidbody.object_add(type=val)
		#bpy.context.object.rigid_body.type = val
		#bpy.ops.rigidbody.mass_calculate(material='Bark', density=0.1)
		RB_Set_RND_Mass(obj,10,500)
		Restore_Selected(inter)
########################################################################## 
def RB_Set_Mass_Sel(ma=100):
	for obj in bpy.context.selected_objects:
		RB_Set_Mass(obj,ma)
########################################################################## 
def RB_Set_Mass(obj,ma):
	cprint(obj)
	obj.rigid_body.mass = ma
########################################################################## 
def RB_Set_RND_Mass_Sel(min=100,max=1000):
	for obj in bpy.context.selected_objects:
		RB_Set_RND_Mass(obj,min,max)
########################################################################## 
def RB_Set_RND_Mass(obj,min=100,max=1000):
	ma=r.uniform(min,max)
	RB_Set_Weight(obj,ma)
########################################################################## 
def RB_Set_Weight(obj,weig=1000):
	obj.rigid_body.mass = weig
########################################################################## 
def RB_Get_Weight(obj):
	wei=obj.rigid_body.mass
	return wei
########################################################################## 
def RB_Set_Full_BB(typ):
	bpy.ops.rigidbody.shape_change(type=typ)
	print("BB was set to "+str(typ))
########################################################################## 
def RB_SetBB(typ='B'):
	ty=RB_Get_BB_Type(typ)
#bpy.context.object.rigid_body.type = type 
	bpy.ops.rigidbody.shape_change(type=ty)
########################################################################## 
def SB_Add_Collision_selected():
	inter=Remember_Selected()
	alo=list()
	for obj in bpy.context.selected_objects:
		alo.append(obj)
	Deselect_All()
	for i in alo:
		obj=i
		Set_Active_Object(obj)
		obj.select_set(state=True)
		Add_Active_as_Collision()
	Restore_Selected(inter)
########################################################################## 
def SB_Remove_SB_selected():
	inter=Remember_Selected()
	alo=list()
	for obj in bpy.context.selected_objects:
		alo.append(obj)
	Deselect_All()
	for i in alo:
		obj=i
		Set_Active_Object(obj)
		obj.select_set(state=True)
		Remove_Softbody_from_Active()
	Restore_Selected(inter)
########################################################################## 
def SB_Remove_Collision_selected():
	inter=Remember_Selected()
	alo=list()
	for obj in bpy.context.selected_objects:
		alo.append(obj)
	Deselect_All()
	for i in alo:
		obj=i
		Set_Active_Object(obj)
		obj.select_set(state=True)
		Remove_Collision_from_Active()
	Restore_Selected(inter)
########################################################################## 	 
def Add_Active_as_Collision():
	bpy.ops.object.modifier_add(type='COLLISION')
########################################################################## 		 
def Remove_Collision_from_Active():
	bpy.ops.object.modifier_remove(modifier="Collision")
########################################################################## 
def Remove_Softbody_from_Active():
	bpy.ops.object.modifier_remove(modifier="Softbody")
########################################################################## 
def SB_Add_Active():
	bpy.ops.object.modifier_add(type='SOFT_BODY')
	bpy.ops.object.modifier_add(type='COLLISION')
	bpy.context.object.modifiers["Softbody"].settings.use_goal = False
	bpy.context.object.modifiers["Softbody"].settings.use_edges = True
	bpy.context.object.modifiers["Softbody"].settings.use_self_collision = True
	bpy.context.object.modifiers["Softbody"].settings.use_edge_collision = True
	bpy.context.object.modifiers["Softbody"].settings.use_face_collision = True
	bpy.context.object.modifiers["Softbody"].settings.use_stiff_quads = True
	bpy.context.object.modifiers["Softbody"].settings.use_auto_step = True
	bpy.context.object.modifiers["Softbody"].settings.bend = 1
	bpy.context.object.modifiers["Softbody"].settings.pull = 0.1
	bpy.context.object.modifiers["Softbody"].settings.push = 0.1

########################################################################## 
def SB_Add_Object(obj):
	inter=Remember_Selected()
	Set_Active_Object(obj)
	obj.select_set(state=True)
	SB_Add_Active()
	Restore_Selected(inter)
########################################################################## 
def SB_Add_selected():
	inter=Remember_Selected()
	alo=list()
	for obj in bpy.context.selected_objects:
		alo.append(obj)
	Deselect_All()
	for i in alo:
		obj=i
		Set_Active_Object(obj)
		obj.select_set(state=True)
		SB_Add_Active()
	Restore_Selected(inter)
########################################################################## 
# Zuerst Objekte markieren die den Modiefier bekommen sollen, dann 
# das Objekt das den / die Modifier hat. 
def Copy_SB_Modifiers():
	bpy.ops.object.make_links_data(type='MODIFIERS')


########################################################################## 
########################################################################## 
# 
#  Mantaflow 
# 
########################################################################## 
########################################################################## 
# Aktives Objekt wird FLUID-Effektor 
def MF_SetEffector():
	obj=Get_Last_Object()
	obj.name='Effector'
	bpy.ops.object.modifier_add(type='FLUID')
	bpy.context.object.modifiers["Fluid"].fluid_type = 'EFFECTOR'
	bpy.context.object.modifiers["Fluid"].effector_settings.subframes = 5
	bpy.context.object.modifiers["Fluid"].effector_settings.surface_distance = 0.01
########################################################################## 
# Aktives Objekt wird FLUID-Domain 
def MF_SetDomain():
	obj=Get_Last_Object()
	obj.name='Domain'
	bpy.ops.object.modifier_add(type='FLUID')
	bpy.context.object.modifiers["Fluid"].fluid_type = 'DOMAIN'
	bpy.context.object.modifiers["Fluid"].domain_settings.domain_type = 'LIQUID'
	bpy.context.object.modifiers["Fluid"].domain_settings.cache_directory = "\\cache"
# Needs to be "FINAL" for 2.83 and "ALL" for 2.90 
	try:
		bpy.context.object.modifiers["Fluid"].domain_settings.cache_type = 'ALL'
	except:
		bpy.context.object.modifiers["Fluid"].domain_settings.cache_type = 'FINAL'
	bpy.context.object.modifiers["Fluid"].domain_settings.use_mesh = True
	bpy.context.object.modifiers["Fluid"].domain_settings.delete_in_obstacle = True
	bpy.context.object.modifiers["Fluid"].domain_settings.use_flip_particles = True
########################################################################## 
def MF_Bake():
	tm=Start_Timer()
	Res=list()
	for obj in bpy.context.scene.objects:
		if obj.name=='Domain':
			Res=Remember_Selected()
			Deselect_All()
			bpy.context.view_layer.objects.active = obj
			Select_Object(obj)
			print("Baking")
			bpy.ops.fluid.bake_all()
			time.sleep(1)
			print("Ok")
			Restore_Selected(Res)
			break
	End_Timer(tm)
########################################################################## 
def MF_SetInFlow():
	obj=Get_Last_Object()
	obj.name='Inflow'
	bpy.ops.object.modifier_add(type='FLUID')
	bpy.context.object.modifiers["Fluid"].fluid_type = 'FLOW'
	bpy.context.object.modifiers["Fluid"].flow_settings.flow_type = 'LIQUID'
	bpy.context.object.modifiers["Fluid"].flow_settings.flow_behavior = 'INFLOW'
	bpy.context.object.modifiers["Fluid"].flow_settings.subframes = 10
########################################################################## 
def MF_SetOutFlow():
	obj=Get_Last_Object()
	obj.name='Outflow'
	bpy.ops.object.modifier_add(type='FLUID')
	bpy.context.object.modifiers["Fluid"].fluid_type = 'FLOW'
	bpy.context.object.modifiers["Fluid"].flow_settings.flow_type = 'LIQUID'
	bpy.context.object.modifiers["Fluid"].flow_settings.flow_behavior = 'OUTFLOW'
	bpy.context.object.modifiers["Fluid"].flow_settings.subframes = 10
########################################################################## 
########################################################################## 
# 
# BITs and MAth 
########################################################################## 
########################################################################## 
# Num - Bit-Nr. 1-8 
# Zahl - Zahl wo das Bit geprüft wird 
# Rückgabe ist 0/1 ob das Bit gesetzt ist 
def IfBit(Num,Zahl):
	Num=Num-1
	val=1<<Num
	if (Zahl&val)>0:
		res=1
	else:
		res=0
	return res
########################################################################## 
def sin(n):
	res=m.sin(n)
	return res
########################################################################## 
def cos(n):
	res=m.cos(n)
	return res

########################################################################## 
# Sind zwei Werte gleich nach Abzug von XY Prozent 
# Beispiel: Wenn a=10 und Perc=90 dann muss b zwischne 9 und 11 sein damit True herauskommt 
# a = 100% 
# b (wenn perc=90) darf nicht >110 oder <90 sein 
# Tested 2.80 
def Is_Equal_Percent(a,b,perc=90):
	if perc>100:
		perc=100
	if perc<1:
		perc=1
	if perc==100:
		ak=int(a*10000)/10000
		bv=ak
	else:
		ak=(a/100)*(100-perc)
		bv=(a/100)*(100+perc)
	bk=int(b*10000)/10000
	if bk>=ak and bk<=bv:
		res=True
	else:
		res=False
	return res

########################################################################## 
########################################################################## 
# Geometrical stuff 
########################################################################## 
########################################################################## 

# ob.bound_box[i][j] 
# Where i is the index of the bounding box corner vertex. 
# Every bounding box is a cuboid and thus has 8 vertices. j is the coordinate of this point, 0 for x, 1 for y and 2 for z. 
# So finding the bounding box length along local axes you could do 

########################################################################## 
def Rounded_Size(obj,ve=3):
	a=Geo_Size_Vect_obj(obj,ve)
	b=int(a*10000)/10000
	return b
########################################################################## 
# Tested 2.8 
# ve = 3: x,y,z  ve= 0-x, 1-y,2-z 
def Select_Similar_Size(ve=3):
	Store=Remember_Selected()
	Deselect_All()
	for obj in Store:
		Select_Similar_Size_obj(obj,0,ve)
########################################################################## 
# Tested 2.8 
# ve = 3: x,y,z  ve= 0-x, 1-y,2-z 
def Select_Similar_Size_obj(obi,des=1,ve=3):
	osi=Rounded_Size(obi,ve)
	for obj in bpy.context.scene.objects:
		oba=Rounded_Size(obj,ve)
		if (oba==osi):
			Select_Object(obj)
		else:
			if des==1:
				DeSelect_Object(obj)
########################################################################## 
def Show_Rounded_Size(ve=3):
	for obj in bpy.context.selected_objects:
		osi=Rounded_Size(obj,ve)
		print(obj)
		print("Rounded Size is "+str(osi))
########################################################################## 
# 
def Select_Similar_Size_Percent_obj(obi,perc=90,ve=3):
	osi=Geo_Size_Vect_obj(obi,ve)
	for obj in bpy.context.scene.objects:
		print(obj)
		oba=Geo_Size_Vect_obj(obj,ve)
		if Is_Equal_Percent(osi,oba,perc):
			Select_Object(obj)
		else:
			DeSelect_Object(obj)
########################################################################## 
def Select_Similar_Size_Percent(perc=90,ve=3):
	obb=Get_Last_Object()
	Select_Similar_Size_Percent_obj(obb,perc,ve)
########################################################################## 
########################################################################## 
# 
# Polygons and Vertices 
# 
########################################################################## 
########################################################################## 
# Arbeitet nur mit einem einzelnen Object 
# Polygon is a single face, can be quadratic (=2 Triangels) or other. 
def Polygons_Count_Single_Object(obj):
	#data = Get_active_Object_Data()
	try:
		data = obj.data
		Poly=len(data.polygons)
	except:
		Poly=0
	return Poly
########################################################################## 
# Vertices -> Ecken (Würfel hat 8) 
# Arbeitet nur mit einem einzelnen Object 
def Vertices_Count_Single_Object(obj):
	#data = Get_active_Object_Data()
	try:
		data = obj.data
		V=len(data.vertices)
	except:
		V=0
	return V
########################################################################## 
# #data = Get_active_Object_Data() 
# 1 - x, 2 - y, 4 - z (längste Seite) 
# 3 - x+y gleichlang und länger als z 
# 7 - alle gleichlang # 
# [10] - max_side 
def GetMinMax(obj):
	data = obj.data
	xk=99e6
	xg=-99e6
	yg=xg
	yk=xk
	zg=xg
	zk=xk
	for vertex in data.vertices:
		pos=vertex.co[0]
		xk=min([pos,xk])
		xg=max([pos,xg])
		pos=vertex.co[1]
		yk=min([pos,yk])
		yg=max([pos,yg])
		pos=vertex.co[2]
		zk=min([pos,zk])
		zg=max([pos,zg])
	xdif=xg-xk
	ydif=yg-yk
	zdif=zg-zk
	if xdif>ydif and xdif>zdif:
		gs=1
		max_side=xdif
	elif ydif>xdif and ydif>zdif:
		gs=2
		max_side=ydif
	elif ydif==xdif and ydif>zdif:
		gs=3
		max_side=ydif
	elif zdif>xdif and zdif>ydif:
		gs=4
		max_side=zdif
	elif ydif>xdif and ydif==zdif:
		gs=5
		max_side=ydif
	elif zdif==xdif and zdif>ydif:
		gs=6
		max_side=zdif
	else:
#ydif==xdif and ydif==zdif: 
		gs=7
		max_side=xdif
# kleinste x und größte x-Werte (xk, xg) ... größte Differenz der X-Werte (xdif) 
# gs - längste Seite (s.o.) 
	xl=obj.location[0]
	xk+=xl
	xg+=xl
	yl=obj.location[1]
	yk+=yl
	yg+=yl
	zl=obj.location[2]
	zk+=zl
	zg+=zl
	erg=[xk,xg,yk,yg,zk,zg,xdif,ydif,zdif,gs,max_side]
	return erg

########################################################################## 
# Arbeitet nur mit einem einzelnen Object 
# Quadratic faces are 2 triangels each 
def Triangles_Count_Single_Object(obj):
	#data = Get_active_Object_Data()
	data = obj.data
	total_triangles=0
	try:
		for face in data.polygons:
			vertices = face.vertices
			triangles = len(vertices) - 2
			total_triangles += triangles
	except:
		total_triangles=0
	return total_triangles

########################################################################## 
# Bounding Box from Object 
# returns lenght of longest side 
# There should be 6 values in ob.bound_box (x_min,y_min,z_min) and (x_max,y_max,z_max) 
def BB_Size(ob):
	bb = ob.bound_box
	dx_local = max(bb[i][0] for i in range(8)) - min(bb[i][0] for i in range(8))
	dy_local = max(bb[i][1] for i in range(8)) - min(bb[i][1] for i in range(8))
	dz_local = max(bb[i][2] for i in range(8)) - min(bb[i][2] for i in range(8))
	longest_side = max(dx_local*ob.scale[0], dx_local*ob.scale[1], dx_local*ob.scale[2])
	return longest_side
########################################################################## 
# Bounding Box from Object 
# returns medium sidelength 
# There should be 6 values in ob.bound_box (x_min,y_min,z_min) and (x_max,y_max,z_max) 
def BB_Size_med(ob):
	bb = ob.bound_box
	dx_local = max(bb[i][0] for i in range(8)) - min(bb[i][0] for i in range(8))
	dy_local = max(bb[i][1] for i in range(8)) - min(bb[i][1] for i in range(8))
	dz_local = max(bb[i][2] for i in range(8)) - min(bb[i][2] for i in range(8))

	mx_local = min(bb[i][0] for i in range(8)) - max(bb[i][0] for i in range(8))
	my_local = min(bb[i][1] for i in range(8)) - max(bb[i][1] for i in range(8))
	mz_local = min(bb[i][2] for i in range(8)) - max(bb[i][2] for i in range(8))

	ss = min(mx_local*ob.scale[0], mx_local*ob.scale[1], mx_local*ob.scale[2])
	ls = max(dx_local*ob.scale[0], dx_local*ob.scale[1], dx_local*ob.scale[2])
	med=(ss+ls)/2
	return med
########################################################################## 
# Bounding Box from Object 
# returns shortest sidelength 
# There should be 6 values in ob.bound_box (x_min,y_min,z_min) and (x_max,y_max,z_max) 
def BB_Size_short(ob):
	bb = ob.bound_box
	mx_local = min(bb[i][0] for i in range(8)) - max(bb[i][0] for i in range(8))
	my_local = min(bb[i][1] for i in range(8)) - max(bb[i][1] for i in range(8))
	mz_local = min(bb[i][2] for i in range(8)) - max(bb[i][2] for i in range(8))

	ss = min(mx_local*ob.scale[0], mx_local*ob.scale[1], mx_local*ob.scale[2])
	return ss
########################################################################## 

########################################################################## 
# Bestimmt Ausdehnung des Objektes 
def Geo_Size_Vect(a=0):
	ob=Get_Active_Object()
	b=Geo_Size_Vect_obj(ob,a)
	return b
########################################################################## 
# Bestimmt Ausdehnung des Objektes 
# 3 - x,y,z / 4 - Triangles-Anz / 5 - Vertices Anz. / 6 - Polygons 
# 0 - x, 1 - y, 2 - z 
def Geo_Size_Vect_obj(obj,a=0):
	x,y,z=obj.dimensions
	if a==3:
		b=m.sqrt(x*x+y*y+z*z)/3
	elif a==4:
		b=Triangles_Count_Single_Object(obj)
	elif a==5:
		b=Vertices_Count_Single_Object(obj)
	elif a==6:
		b=Polygons_Count_Single_Object(obj)
	elif a==0:
		b=x
	elif a==1:
		b=y
	elif a==2:
		b=z
	return b
########################################################################## 
########################################################################## 
# 
# MOVE Objects 
# 
########################################################################## 
########################################################################## 
########################################################################## 
def Geo_Align_X():
	return Geo_Align_Any(0)
########################################################################## 
def Geo_Align_Y():
	return Geo_Align_Any(1)
########################################################################## 
def Geo_Align_Z():
	return Geo_Align_Any(2)
########################################################################## 
# Return 6er Vector mit voriger Pos. der 2 Objekte 
def Geo_Align_Any(dir):
	oba=Get_Active_Object()
	obb=Get_Next_Selected(oba)
	if oba:
		if obb:
			olp=Geo_Align(oba,obb,dir)
			return olp
########################################################################## 
# Return 6er Vector mit voriger Pos. der 2 Objekte 
def Geo_Align(oba,obb,vec=0):
	Siza=Geo_Size_Vect_obj(oba,vec)
	Sizb=Geo_Size_Vect_obj(obb,vec)
	Sizm=Siza/2+Sizb/2
# obc bekommt größeres Objekt, also wird obd bewegt 
	if Siza>Sizb:
		obc=oba
		obd=obb
	else:
		obc=obb
		obd=oba
	olp=Remember_Obj_LR2(obc,obd)

	poc=Get_Object_Any_Location(obc)
	pod=Get_Object_Any_Location(obd)

	ax=obc.rotation_euler.x
	ay=obc.rotation_euler.y
	az=obc.rotation_euler.z
	bx=obd.rotation_euler.x
	by=obd.rotation_euler.y
	bz=obd.rotation_euler.z
	SetRotation(obc,0,0,0)
	SetRotation(obd,0,0,0)

	if vec==0:
		if Geo_Align_int(obc,obd,0):
			xp=obc.location.x+Sizm
		else:
			xp=obc.location.x-Sizm
	else:
		xp=obc.location.x
	if vec==1:
		if Geo_Align_int(obc,obd,1):
			yp=obc.location.y+Sizm
		else:
			yp=obc.location.y-Sizm
	else:
		yp=obc.location.y
	if vec==2:
		if Geo_Align_int(obc,obd,2):
			zp=obc.location.z+Sizm
		else:
			zp=obc.location.z-Sizm
	else:
		zp=obc.location.z
	Setloc(obd,xp,yp,zp)

	bpy.ops.transform.rotate(value=ax, orient_axis='X', orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, True, False), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False, release_confirm=True)
	bpy.ops.transform.rotate(value=ay, orient_axis='Y', orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, True, False), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False, release_confirm=True)
	bpy.ops.transform.rotate(value=az, orient_axis='Z', orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, False, True), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False, release_confirm=True)

# old: poc, pod 
# Neue Loc. des Main-Object 
	noc=Get_Object_Any_Location(obc)
	nod=Get_Object_Any_Location(obd)
	noe=Location_Dif(poc,noc)
	nof=Combine_Loc(noe,nod)
	Restore_Object_Loc(obd,nof)
	Restore_Object_Loc(obc,poc)
	return olp
########################################################################## 
# Return 1/0 ob Objet links oder rechts ist 
def Geo_Align_int(obc,obd,vec):
	va=obc.location[vec]
	vb=obd.location[vec]
	if va<vb:
		e=1
	else:
		e=0
	#print("va="+str(va)+"  vb="+str(vb)+"   e="+str(e))
	return e

########################################################################## 
def Center_Align_To_Active(n):
	oba=Get_Active_Object()
	for obj in bpy.context.selected_objects:
		if obj!=oba:
			xp,yp,zp=obj.location
			tx,ty,tz=oba.location
			if IfBit(1,n):
				xp=tx
			if IfBit(2,n):
				yp=ty
			if IfBit(3,n):
				zp=tz
			olp=Remember_Obj_LR2(oba,obj)
			Setloc(obj,xp,yp,zp)
			return olp
########################################################################## 

def Geo_Move_Right_by_own_SizeX():
	a=Geo_Size_Vect(0)
	Move_selected_ObjectX(a)
########################################################################## 
def Geo_Move_Away_by_own_SizeY():
	a=Geo_Size_Vect(1)
	Move_selected_ObjectY(a)
########################################################################## 
def Geo_Move_Up_by_own_SizeZ():
	a=Geo_Size_Vect(2)
	Move_selected_ObjectZ(a)
########################################################################## 
def Geo_Move_Left_by_own_SizeX():
	a=Geo_Size_Vect(0)
	Move_selected_ObjectX(-a)
########################################################################## 
def Geo_Move_Near_by_own_SizeY():
	a=Geo_Size_Vect(1)
	Move_selected_ObjectY(-a)
########################################################################## 
def Geo_Move_Down_by_own_SizeZ():
	a=Geo_Size_Vect(2)
	Move_selected_ObjectZ(-a)
########################################################################## 
########################################################################## 
def Geo_Move_Right_by_half_SizeX():
	a=Geo_Size_Vect(0)
	b=a/2
	Move_selected_ObjectX(b)
########################################################################## 
def Geo_Move_Away_by_half_SizeY():
	a=Geo_Size_Vect(1)
	b=a/2
	Move_selected_ObjectY(b)
########################################################################## 
def Geo_Move_Up_by_half_SizeZ():
	a=Geo_Size_Vect(2)
	b=a/2
	Move_selected_ObjectZ(b)
########################################################################## 
def Geo_Move_Left_by_half_SizeX():
	a=Geo_Size_Vect(0)
	b=a/2
	Move_selected_ObjectX(-b)
########################################################################## 
def Geo_Move_Near_by_half_SizeY():
	a=Geo_Size_Vect(1)
	b=a/2
	Move_selected_ObjectY(-b)
########################################################################## 
def Geo_Move_Down_by_half_SizeZ():
	a=Geo_Size_Vect(2)
	b=a/2
	Move_selected_ObjectZ(-b)
########################################################################## 
########################################################################## 
# Remember, Restore and Lists 
# 
########################################################################## 
########################################################################## 
# Aufruf 
# GA=list() 
# GA=Remember_Selected() 
def Remember_Selected():
	act=Get_Active_Object()
	asl=bpy.context.selected_objects
	asl.insert(0,act)
	return asl
########################################################################## 
def Restore_Selected(i):
	Deselect_All()
	act=i[0]
	for obj in i:
		Select_Object(obj)
	Set_Active_Object(act)
########################################################################## 
def Restore_UnSelect(i):
	Deselect_All()
	act=i[0]
	for obj in i:
		DeSelect_Object(obj)
	DeSelect_Object(obj)
########################################################################## 
def Restore_Selected_keep_active(i):
	act=Get_Active_Object()
	Restore_Selected(i)
	Set_Active_Object(act)
########################################################################## 
def Restore_Active_keep_Selection(i):
	act=i[0]
	if act:
		Set_Active_Object(act)
########################################################################## 
def Select_List(i):
	for obj in i:
		Select_Object(obj)
########################################################################## 
def Combine_Selection(i,j):
	Deselect_All()
	Select_List(i)
	Select_List(j)
########################################################################## 
def Get_Object_Any_Location(obj):
	xp=obj.location.x
	yp=obj.location.y
	zp=obj.location.z
	vec=MakeList(xp,yp,zp)
	return vec
########################################################################## 
def MakeObjList(obj,xp,yp,zp,vec=list()):
	vec.append(obj)
	vec.append(xp)
	vec.append(yp)
	vec.append(zp)
	return vec

########################################################################## 
def MakeList(xp,yp,zp):
	vec=list()
	vec.append(xp)
	vec.append(yp)
	vec.append(zp)
	return vec

########################################################################## 
def Negate_Object_loc(pos):
	xp=pos[0]*-1
	yp=pos[1]*-1
	zp=pos[2]*-1
	vec=MakeList(xp,yp,zp)
	return vec
########################################################################## 
def Combine_Loc(poa,pob):
	xp=poa[0]+pob[0]
	yp=poa[1]+pob[1]
	zp=poa[2]+pob[2]
	vec=MakeList(xp,yp,zp)
	print("Combine: "+str(xp)+","+str(yp)+","+str(zp))
	return vec
########################################################################## 
def Location_Dif(poa,pob):
	xp=poa[0]-pob[0]
	yp=poa[1]-pob[1]
	zp=poa[2]-pob[2]
	vec=MakeList(xp,yp,zp)
#print("Combine: "+str(xp)+","+str(yp)+","+str(zp)) 
	return vec

########################################################################## 
def Get_neg_Object_Location(obj):
	xp=-(obj.location.x)
	yp=-(obj.location.y)
	zp=-(obj.location.z)
	vec=MakeList(xp,yp,zp)
	print("Save neg.: "+str(xp)+","+str(yp)+","+str(zp))
	return vec
########################################################################## 
def Restore_Shifted_Object_Loc(obj,pos):
	xp=pos[0]+obj.location.x
	yp=pos[1]+obj.location.y
	zp=pos[2]+obj.location.z
#print("Restore: "+str(xp)+","+str(yp)+","+str(zp)) 
	Setloc(obj,xp,yp,zp)

########################################################################## 
def Get_Object_Any_Rotation(obj):
	xp=obj.rotation_euler.x
	yp=obj.rotation_euler.y
	zp=obj.rotation_euler.z
	vec=MakeList(xp,yp,zp)
	return vec
########################################################################## 
def Remember_Obj_Loc(obc):
	olp=list()
	ola=Get_Object_Any_Location(obc)
	olp.append(obc)
	olp.append(ola)
	return olp
########################################################################## 
def Remember_Obj_Rot(obc):
	olp=list()
	ola=Get_Object_Any_Rotation(obc)
	olp.append(obc)
	olp.append(ola)
	return olp
########################################################################## 
def Remember_Obj_LR(obc):
	lpa=Remember_Obj_Loc(obc)
	lpb=Remember_Obj_Rot(obc)
	olp=list()
	olp.append(lpa)
	olp.append(lpb)
	return olp
########################################################################## 
def Remember_Obj_Loc2(obc,obd):
	olp=list()
	ola=Get_Object_Any_Location(obc)
	olb=Get_Object_Any_Location(obd)
	olp.append(obc)
	olp.append(ola)
	olp.append(obd)
	olp.append(olb)
	return olp
########################################################################## 
def Remember_Obj_Rot2(obc,obd):
	olp=list()
	ola=Get_Object_Any_Rotation(obc)
	olb=Get_Object_Any_Rotation(obd)
	olp.append(obc)
	olp.append(ola)
	olp.append(obd)
	olp.append(olb)
	return olp
########################################################################## 
def Remember_Obj_LR2(obc,obd):
	lpa=Remember_Obj_Loc2(obc,obd)
	lpb=Remember_Obj_Rot2(obc,obd)
	olp=list()
	olp.append(lpa)
	olp.append(lpb)
	return olp
########################################################################## 
def Restore_Obj_LR2(vec):
	lpa=vec[0]
	lpb=vec[1]
	if lpa:
		Restore_Object_Loc2(lpa)
	if lpb:
		Restore_Object_Rot2(lpb)
########################################################################## 
def Restore_Object_Loc(obj,pos):
	xp=pos[0]
	yp=pos[1]
	zp=pos[2]
	Setloc(obj,xp,yp,zp)
########################################################################## 
def Restore_Object_Loc2(pos):
	oba=pos.pop(0)
	va=pos.pop(0)
	obb=pos.pop(0)
	vb=pos.pop(0)
	if oba:
		if obb:
			xp=va[0]
			yp=va[1]
			zp=va[2]
			Setloc(oba,xp,yp,zp)
			xp=vb[0]
			yp=vb[1]
			zp=vb[2]
			Setloc(obb,xp,yp,zp)

########################################################################## 
def Restore_Object_Rot2(pos):
	oba=pos.pop(0)
	va=pos.pop(0)
	obb=pos.pop(0)
	vb=pos.pop(0)
	if oba:
		if obb:
			xp=va[0]
			yp=va[1]
			zp=va[2]
			SetRot(oba,xp,yp,zp)
			xp=vb[0]
			yp=vb[1]
			zp=vb[2]
			SetRot(obb,xp,yp,zp)

########################################################################## 
# ' myo.rotation_euler.x 
def Remember_selected_Objects_Rot():
	vec=list()
	cnt=0
	for obj in bpy.context.selected_objects:
		xp=obj.rotation_euler.x
		yp=obj.rotation_euler.y
		zp=obj.rotation_euler.z
		print("xp="+str(xp)+" "+"yp="+str(yp)+" "+"zp="+str(zp))
		vec=MakeObjList(obj,xp,yp,zp,vec)
		cnt=cnt+1
	vec.insert(0,cnt)
	return vec
###################################################################### 
def Restore_Objects_Rot(sto):
#Anzahl Objekte 
	num=sto[0]
	for i in range(num):
		obj=sto[(4*i)+1]
		xp=sto[(4*i)+2]
		yp=sto[(4*i)+3]
		zp=sto[(4*i)+4]
		print("xp="+str(xp)+" "+"yp="+str(yp)+" "+"zp="+str(zp))
		SetRot(obj,xp,yp,zp)
########################################################################## 
def Remember_selected_Objects_Loc():
	vec=list()
	cnt=0
	for obj in bpy.context.selected_objects:
		xp=obj.location.x
		yp=obj.location.y
		zp=obj.location.z
		vec=MakeObjList(obj,xp,yp,zp,vec)
		cnt=cnt+1
	vec.insert(0,cnt)
	return vec
########################################################################## 
def Remember_selected_Objects_Size():
	vec=list()
	cnt=0
	for obj in bpy.context.selected_objects:
		xp,yp,zp=obj.dimensions
		vec=MakeObjList(obj,xp,yp,zp,vec)
		cnt=cnt+1
	vec.insert(0,cnt)
	return vec

#### 
########################################################################## 
def Restore_Objects_Loc(sto):
#Anzahl Objekte 
	num=sto[0]
	for i in range(num):
		obj=sto[(4*i)+1]
		xp=sto[(4*i)+2]
		yp=sto[(4*i)+3]
		zp=sto[(4*i)+4]
		Setloc(obj,xp,yp,zp)
########################################################################## 
def Restore_Objects_Size(sto):
#Anzahl Objekte 
	num=sto[0]
	for i in range(num):
		obj=sto[(4*i)+1]
		xp=sto[(4*i)+2]
		yp=sto[(4*i)+3]
		zp=sto[(4*i)+4]
		Set_ObjSize(obj,xp,yp,zp)
########################################################################## 
########################################################################## 
# 
# Scale and Size Objects 
# 
########################################################################## 
########################################################################## 
# Wirkt auf "Active Object und ein "selected Object") 
# "dir" 0/1 ob larger oder smaller genommen werden soll 
def Make_Same_Size(vec,dir=0):
	oba=Get_Active_Object()
	obb=Get_Next_Selected(oba)
	sb=obb.dimensions[vec]
	sa=oba.dimensions[vec]

#sb=Geo_Size_Vect_obj(obb,vec) 
#sa=Geo_Size_Vect_obj(oba,vec) 

# dir bestimmt ob larger oder smaller 
	if dir==0:
		if sa>sb:
			sc=sa
			tao=oba
			tbb=obb
		else:
			sc=sb
			tao=obb
			tbb=oba
	else:
		if sa<sb:
			sc=sa
			tao=oba
			tbb=obb
		else:
			sc=sb
			tao=obb
			tbb=oba
	tao.dimensions[vec]=tbb.dimensions[vec]
########################################################################## 
# Gibt Objecten eine zufällige Größe zwischen Min und Max 
def RandSize(Min,Max):
	for obj in bpy.context.selected_objects:
		sz = r.uniform(Min,Max)
		obj.scale = (sz,sz,sz)
########################################################################## 
# 
def Set_ObjSizeV(myo,si,vec):
	myo.dimensions[vec]=si
########################################################################## 
def Set_ObjSize(myo,xp,yp,zp):
	myo.dimensions=(xp,yp,zp)
#print("xp="+str(xp)+" "+"yp="+str(yp)+" "+"zp="+str(zp)) 
########################################################################## 
def Set_ObjScaling(xp=1,yp=1,zp=1):
	bpy.ops.transform.resize(value=(xp,yp,zp))
########################################################################## 
def Set_Scale(obj,sx=1,sy=1,sz=1):
	obj.scale = (sx,sy,sz)
########################################################################## 
def SetRotation(myo,xp,yp,zp):
	myo.rotation_euler.x=m.radians(xp)
	myo.rotation_euler.y=m.radians(yp)
	myo.rotation_euler.z=m.radians(zp)
########################################################################## 
def SetRot(myo,xp,yp,zp):
	myo.rotation_euler.x=xp
	myo.rotation_euler.y=yp
	myo.rotation_euler.z=zp
########################################################################## 
# 
def Setloc(myo,xp,yp,zp):
	myo.location = (xp,yp,zp)
	#print("Moving: ",myo.name," to ",xp,yp,zp)
	#myo.location.x=xp
	#myo.location.y=yp
	#myo.location.z=zp
########################################################################## 
########################################################################## 
# 
# Vertices and Faces 
# 
########################################################################## 
########################################################################## 
def calc_center_of_polygon(mesh: bpy.types.Mesh, polygon: bpy.types.MeshPolygon):
	result = mathutils.Vector()
	for vertex in polygon.vertices:
		result += mathutils.Vector(mesh.vertices[vertex].co)
	return result / len(polygon.vertices)
########################################################################## 
def calc_center(mesh: bpy.types.Mesh):
	total_weight = 0.0
	total_center = mathutils.Vector()
	for polygon in mesh.polygons:
		weight = calc_area_of_polygon(mesh, polygon)
		total_weight += weight
		total_center += weight * calc_center_of_polygon(mesh, polygon)
	return total_center / total_weight
########################################################################## 
def Euler_to_Grad(Euler):
	a=float(Euler)
	Grad=m.degrees(a)
	return(Grad)
########################################################################## 
def Grad_to_Eulerx(Grad):
	a=float(Grad)
	Euler=m.radians(a)
	return(Euler)
########################################################################## 
def Vertex_Color_Add():
	bpy.ops.mesh.vertex_color_add()
########################################################################## 
# factor -10-10 
# repeat 1-1000 
# 
def Vertices_selected_Flatten():
	bpy.ops.mesh.vertices_smooth(factor=1.0, repeat=5, xaxis=True, yaxis=True, zaxis=True, wait_for_input=True)
########################################################################## 
# lambda-factorfloat in [1e-07, 1000] 
# 
def Vertices_selected_Laplacian_Smooth():
	bpy.ops.mesh.vertices_smooth_laplacian(repeat=1, lambda_factor=1.0, lambda_border=5e-05, use_x=True, use_y=True, use_z=True, preserve_volume=True)
########################################################################## 
# IN EDIT MODE only! 
# 2 Faces on 2 Objects must be selected! 
def Align_active_Faces():
	import bpy
	from mathutils import Matrix, Vector
	import bmesh

	bpy.ops.object.mode_set(mode='EDIT')

	context = bpy.context
	scene = context.scene
	A = context.object

	A.select_set(state=False)
	B = bpy.context.selected_objects[0]
	A.select_set(state=True)

#obj = context.edit_object (!) equal to A 
	src_mw = A.matrix_world.copy()
	src_bm = bmesh.from_edit_mesh(A.data)
	src_face = src_bm.select_history.active
	src_o = src_face.calc_center_median()
	src_normal = src_face.normal
	src_tan = src_face.calc_tangent_edge()

# This is the target, we change the sign of normal to stick face to face 
	dst_mw = B.matrix_world.copy()
	dst_bm = bmesh.from_edit_mesh(B.data)
	dst_face = dst_bm.select_history.active
	dst_o = dst_face.calc_center_median()
	dst_normal = -(dst_face.normal)
	dst_tan = (dst_face.calc_tangent_edge())

	vec2 = src_normal @ src_mw.inverted()
	matrix_rotate = dst_normal.rotation_difference(vec2).to_matrix().to_4x4()

	vec1 = src_tan @ src_mw.inverted()
	dst_tan = dst_tan @ matrix_rotate.inverted()
	mat_tmp = dst_tan.rotation_difference(vec1).to_matrix().to_4x4()
	matrix_rotate = mat_tmp @ matrix_rotate
	matrix_translation = Matrix.Translation(src_mw @ src_o)

# This line applied the matrix_translation and matrix_rotate 
	B.matrix_world = matrix_translation @ matrix_rotate.to_4x4()

# We need to recalculate these value since we change the matrix_world 
	dst_mw = B.matrix_world.copy()
	dst_bm = bmesh.from_edit_mesh(B.data)
	dst_face = dst_bm.select_history.active
	dst_o = dst_face.calc_center_median()

# The following is telling blender to find a translation from face center to origin, 
# And than apply it on world matrix 
# Be Careful, the order of the matrix multiplication change the result, 
# We always put the transform matrix on "Left Hand Side" to perform the task 
	dif_mat = Matrix.Translation(B.location - dst_mw @ dst_o)
	B.matrix_world = dif_mat @ B.matrix_world
########################################################################## 
# Distance between the Object-Centerpoints 
def Obj_Distance(p1, p2):
	x1,y1,z1=p1.location
	x2,y2,z2=p2.location
	dia=Geo_Point_Distance(x1,y1,z1,x2,y2,z2)
	Sia=BB_Size(p1)/2
	Sib=BB_Size(p2)/2
	dis=dia-(Sia+Sib)
	return dis
########################################################################## 
def Abs_Distance(oba,obb):
	dia=Obj_Distance(oba,obb)
	dis=abs(dia)
	return dis
########################################################################## 
def Simple_Distance(oaa,obb):
	ea=oaa.location
	eb=obb.location
	dis=distance(ea,eb)
	return dis
########################################################################## 
def Geo_Distance(oba,obb):
	loc1 = oba.location
	loc2 = obb.location

	xlen = loc1.x - loc2.x
	ylen = loc1.y - loc2.y
	zlen = loc1.z - loc2.z
	dist = m.sqrt(xlen**2 + ylen**2 + zlen**2)
	return dist
########################################################################## 
def Geo_Point_Distance(x1,y1,z1,x2,y2,z2):
	dia=m.sqrt((x1-x2)**2+(y1-y2)**2+(z1-z2)**2)
	return dia
########################################################################## 
def Join_Selected():
	bpy.ops.object.join()
########################################################################## 
# by can be 'SELECTED', 'MATERIAL', 'LOOSE' 
# cent ='ORIGIN_CENTER_OF_MASS'or 'ORIGIN_GEOMETRY' 
def Unjoin_by_Loose_Parts(by='LOOSE',cent='ORIGIN_GEOMETRY'):
	now=Start_Timer()
	bpy.ops.object.mode_set(mode='EDIT')
	bpy.ops.mesh.separate(type=by)
	bpy.ops.object.mode_set(mode='OBJECT')
	bpy.ops.object.origin_set(type=cent, center='MEDIAN')
	End_Timer(now)
########################################################################## 
# Edges (Kanten) 
########################################################################## 
def Get_active_Object_Data():
	obj = Get_Active_Object()
	data = obj.data
	return data
########################################################################## 
########################################################################## 
# 
# Bullet-Scenes 
# 
########################################################################## 

##########################################################################	
#('RANDOM', "Random", ""),
#('SIZE_MIN', "Small", "Recursively subdivide smaller objects"),
#('SIZE_MAX', "Big", "Recursively subdivide bigger objects"),
#('CURSOR_MIN', "Cursor Close", "Recursively subdivide objects closer to the cursor"),
#('CURSOR_MAX', "Cursor Far", "Recursively subdivide objects farther from the cursor"), 	
#https://lists.blender.org/pipermail/bf-extensions-cvs/2019-July/008339.html 
# rec -> Recursion Depth
# rcc -> Probability for recursion 
# un -> maximum number of generated objects
# rsl -> maximum recursion
#  
def GlasBreak(rec=7,rcc=.25,un=2500,rsl=8,tar='CURSOR_MIN'):
	GI=Remember_Selected()
	opr="Glasbreak_"+str(r.uniform(0,9999))
	bpy.ops.object.add_fracture_cell_objects(source={'PARTICLE_OWN'},
	source_limit=100,
	source_noise=.5,
	cell_scale=(1, 1, 1),
	recursion=rec,
	recursion_source_limit=rsl,
	recursion_clamp=un,
	recursion_chance=rcc,
	recursion_chance_select=tar,
	use_smooth_faces=False,
	use_sharp_edges=True,
	use_sharp_edges_apply=True,
	use_data_match=True,
	use_island_split=True,
	margin=0.01,
	material_index=1,
	use_interior_vgroup=False,
	mass_mode='VOLUME',
	mass=1,
	use_recenter=True,
	use_remove_original=True,
	collection_name=opr,
	use_debug_points=False,
	use_debug_redraw=False,
	use_debug_bool=False)
	Restore_Selected(GI)
	cprint("Glasbreak Ok.")
	return opr
########################################################################## 
# rec -> Recursion Depth
# rcc -> Probability for recursion 
# un -> maximum number of generated objects
# rsl -> maximum recursion
#  
def Cellfrac(rec=5,rcc=.25,un=2500,rsl=8,tar='SIZE_MAX'):
	#GI=Remember_Selected()
	opr="Glasbreak_"+str(r.uniform(0,9999))
	bpy.ops.object.add_fracture_cell_objects(source={'VERT_OWN'},
	source_limit=100,
	source_noise=0.0,
	cell_scale=(1, 1, 1),
	recursion=rec,
	recursion_source_limit=rsl,
	recursion_clamp=un,
	recursion_chance=rcc,
	recursion_chance_select=tar,
	use_smooth_faces=True,
	use_sharp_edges=True,
	use_sharp_edges_apply=False,
	use_data_match=True,
	use_island_split=True,
	margin=0.01,
	material_index=1,
	use_interior_vgroup=True,
	mass_mode='VOLUME',
	mass=1,
	use_recenter=True,
	use_remove_original=True,
	collection_name=opr,
	use_debug_points=False,
	use_debug_redraw=False,
	use_debug_bool=False)
	#Restore_UnSelect(GI)
	cprint("Glasbreak Ok.")
	return opr
########################################################################## 
##########################################################################	 
# Will make Cell Fracture 
def New_Cell_Collection():
	Col=NewCollection("Fract")
	#Cell_Fracture_Selected()
	CellFracture(True)
	for obj in bpy.context.selected_objects:
		MoveObjToCollection(Col,obj)
	Deselect_All()
##########################################################################	 
# from: https://blender.stackexchange.com/questions/189412/how-to-create-cell-fracture-in-python 
# 
def Cell_Fracture_Selected_A():
		enable("object_fracture_cell")
		bpy.ops.object.add_fracture_cell_objects(
		source={'PARTICLE_OWN'},
		source_limit=100,
		source_noise=0,
		cell_scale=(1, 1, 1),
		recursion=0,
		recursion_source_limit=8,
		recursion_clamp=250,
		recursion_chance=0.25,
		recursion_chance_select='SIZE_MIN',
		use_smooth_faces=False,
		use_sharp_edges=True,
		use_sharp_edges_apply=True,
		use_data_match=True,
		use_island_split=True,
		margin=0.001,
		material_index=0,
		use_interior_vgroup=False,
		mass_mode='VOLUME',
		mass=1,
		use_recenter=True,
		use_remove_original=True,
		collection_name="Fracture",
		use_debug_points=False,
		use_debug_redraw=True,
		use_debug_bool=False)
		cprint("CF Ok")
		RB_RigidBodyAdd_Intelligent()
		cprint("RB Ok")

########################################################################## 
def Make_BulletA():
#Move Objects and Slider to Target-Pos. 
	tf=Get_Actual_KF()
	Set_LocRot_Keyframe_selected()
	RB_AddSelectedObjects(pa=1)
	RB_Set_KinDyn(tf,1)
########################################################################## 
def Make_BulletB():
#Move Objects and Slider to Starting-Pos. 
	tf=Get_Actual_KF()
	Set_LocRot_Keyframe_selected()
	RB_Set_KinDyn(tf,0)
########################################################################## 	 
# If Wi>0 Object will also rotate during flight 
def Make_Single_Bullet(obj,sx,sy,sz,tx,ty,tz,skf,ekf,wi=0):
	Inter=Remember_Selected()
	Deselect_All()
	Make_Single_Bullet_int(obj,sx,sy,sz,tx,ty,tz,skf,ekf,wi)
	Restore_Selected(Inter)

########################################################################## 
########################################################################## 
# Make an existing Object as a "bullet" 
# that flies from sx,sy,sz to tx,ty,tz during Keyframe skf to ekf 
# In the Keyframe ekf+1 it will switch to RB-Physics 
# 
# If Wi>0 Object will also rotate during flight 
# obj - Obj-ID 
# sx,sy,sz - Startposition 
# tx,ty,tz - Target-Position 
# skf - Start-Keyframe 
# ekf - End-Keyframe 
# wi - max. random Angle of rotation through all 3 Axis during flight 
# 
def Make_Single_Bullet_int(obj,sx,sy,sz,tx,ty,tz,skf,ekf,wi=0):
	okf=Get_Actual_KF()
	#Set_Active_Object(obj)
	RB_Add_Single_Object(obj)
	#RB_Set_RND_Mass(obj,1500,2000)
	Setloc(obj,sx,sy,sz)
	#print('Setting Loc.:'+str(sx)+","+str(sy)+","+str(sz)+", Start-Frame:"+str(skf))
	Keyframe_LR(obj,skf)
	RB_Set_KinDyn_Object(obj,skf,0)
	#Apply_Location(obj)
	Setloc(obj,tx,ty,tz)
	if wi>0:
		Random_Rotate_Object(obj,wi)
	#print('Setting Loc.:'+str(tx)+","+str(ty)+","+str(tz)+", Tar-Frame:"+str(ekf))
	Keyframe_LR(obj,ekf)
	RB_Set_KinDyn_Object(obj,ekf,1)
	Set_Actual_KF(okf)
########################################################################## 
# Create a copy of an existing Object as a "bullet" 
# that flies from sx,sy,sz to tx,ty,tz during Keyframe skf to ekf 
# In the Keyframe ekf+1 it will switch to RB-Physics 
# 
# If Wi>0 Object will also rotate during flight 
# obj - Obj-ID 
# col - Collection where the original Object is 
# sx,sy,sz - Startposition 
# tx,ty,tz - Target-Position 
# skf - Start-Keyframe 
# ekf - End-Keyframe 
# wi - max. random Angle of rotation through all 3 Axis during flight 
# 
def Create_Bullet_real(obj,col,sx,sy,sz,tx,ty,tz,skf,ekf,wi=0):
	#Inter=Remember_Selected()
	if Exist_Object(obj)==False:
		return
	Deselect_All()
	#obn=Make_Linked(obj,0)
	obn=Copy_Object(obj,col)
	Make_Single_Bullet_int(obn,sx,sy,sz,tx,ty,tz,skf,ekf,wi)
	return obn
########################################################################## 
# Create a copy of an existing Object as a "bullet" 
# that flies from sx,sy,sz to tx,ty,tz during Keyframe skf to ekf 
# In the Keyframe ekf+1 it will switch to RB-Physics 
# 
# If Wi>0 Object will also rotate during flight 
# obj - Obj-ID 
# sx,sy,sz - Startposition 
# tx,ty,tz - Target-Position 
# skf - Start-Keyframe 
# ekf - End-Keyframe 
# wi - max. random Angle of rotation through all 3 Axis during flight 
# 
def Create_Bullet(obj,sx,sy,sz,tx,ty,tz,skf,ekf,wi=0):
	#Inter=Remember_Selected()
	if Exist_Object(obj)==False:
		return
	Deselect_All()
	obn=Make_Linked(obj,0)
	Make_Single_Bullet_int(obn,sx,sy,sz,tx,ty,tz,skf,ekf,wi)
	return obn
	#Restore_Selected(Inter)
########################################################################## 
# obj - Objekt to Spike from 
# lnx - Lenght of Spikes (shorter = faster) 
# flg - 0 - Spikes hide in orginal object >0 - Spike start outside Object. 
def Get_SpikeA(obj,lnx=4):
	op=list()
	oloc=obj.location
	odim=obj.dimensions
	for dix in range(-1,2,1):
		for diy in range(-1,2,1):
			for diz in range(-1,2,1):
				np=Get_Spikes_int(dix,diy,diz,lnx,oloc,odim)
				op.append(np)
	return op
########################################################################## 
# 
def Get_Spikes_int(dirx=1,diry=1,dirz=1,ln=4,oloc=[0,0,0],odim=[1,1,1]):
	x,y,z=oloc
	if ln==0:
		xp=x
		yp=y
		zp=z
	else:
		sx,sy,sz=odim
		lenx=ln*dirx
		leny=ln*diry
		lenz=ln*dirz
		xc=sx*lenx
		yc=sy*leny
		zc=sz*lenz
		xp=x+xc
		yp=y+yc
		zp=z+zc
	np=[xp,yp,zp]
	return np
########################################################################## 	 
# ln - Length of outer Spike, distance from Object in Object-size as Unit 1 
# flg - Inner Spike (inner Startpoint) distance from Object in Object-size as Unit 1 
def Generate_Spikes(oba,ln=4,flg=0):
# Get Endpos for Spikes 
	ip=Get_SpikeA(oba,ln)
# Get Starpos for Spikes 
	jp=Get_SpikeA(oba,flg)
	np=[jp,ip]
	return np
########################################################################## 
# Explodes the given Object generate REAL Objects if real=1 
#	 
def Explode_Object_B(obj,col=0,kfa=1,kfi=10,ln=4,real=1,dep=2):
	fac=.75
	if kfa<0:
		kfa=Get_Actual_KF()
	if col==0:
		col=NewCollection('Bullets from Explode')
#x,y,z=obj.location 
	kft=kfa+kfi
	pala=list()
	#pala.append(kft)
	sx,sy,sz=obj.dimensions*fac
	cn=Generate_Spikes(obj,ln)
	sp=cn[0]
	ep=cn[1]
	lnx=len(sp)
	dep*=9
	for i in range(0,lnx):
		x,y,z=sp[i]
		xp,yp,zp=ep[i]
		if real==1:
			obn=Create_Bullet_real(obj,col,x,y,z,xp,yp,zp,kfa,kft)
		else:
			obn=Create_Bullet(obj,x,y,z,xp,yp,zp,kfa,kft)
			MoveObjToCollection(col,obn)
			Set_ObjSize(obn,sx,sy,sz)
			pala.append([kft,obn])
			if dep>0:
				dep=dep-1
				Explode_Object_B(obn,0,kft,10,4,1,dep)
	return pala
########################################################################## 
# Explode all selected Objects, generate real Duplicates 
# col - Outliner Collection ID 
# kfa - Start-Keyframe 
# kfi - Animatiopn Length in Keyframes 
# 
def Explode_Objects_real(col=0,kfa=-9999,kfi=10,tim=1,lnx=4,dep=1):
	va=Remember_Start()
	Use=va[2]
	Use.pop(0)
	print(Use)
	if kfa==-9999:
		kfa=Get_Actual_KF()
	if col==0:
		col=NewCollection('Bullets from Explode')
	cna=len(Use)
	re=list()
	for nj in range(0,tim):
		for obj in Use:
			Deselect_All()
			bac=Explode_Object_B(obj,col,kfa,kfa+kfi,lnx,dep)
			re.append(bac)
			kfa+=kfi

	Restore_Start(va)
	print('OK with: '+str(cna)+" Elements.")
	return re
########################################################################## 
# Explode all selected Objects, generate linked Duplicates 
# col - Outliner Collection ID 
# kfa - Start-Keyframe 
# kfi - Animation Length in Keyframes 
# 
def Explode_Objects(col=0,kfa=-9999,kfi=10,tim=1,lnx=4):
	va=Remember_Start()
	Use=va[2]
	Use.pop(0)
	print(Use)
	if kfa==-9999:
		kfa=Get_Actual_KF()
	if col==0:
		col=NewCollection('Bullets from Explode')
	cna=len(Use)
	re=list()
	for nj in range(0,tim):
		for obj in Use:
			Deselect_All()
			bac=Explode_Object_int(obj,col,kfa,kfa+kfi,lnx)
			re.append(bac)
			kfa+=kfi

	Restore_Start(va)
	print('OK with: '+str(cna)+" Elements.")
	return re

########################################################################## 
# Explodes the given Object to linked Duplicates 
# 
def Explode_Object_int(obj,col=0,kfa=1,kfi=10,ln=4):
	fac=0.5
	if col==0:
		col=NewCollection('Bullets from Explode')
	x,y,z=obj.location
	sx,sy,sz=obj.dimensions/fac
	# Get Endpos for Spikes
	ip=Get_SpikeA(obj,ln)
	# Get Starpos for Spikes
	jp=Get_SpikeA(obj,1)

	kft=kfa+kfi
	pala=list()
	pala.append(kft)
	for ve in ip:
		xp,yp,zp=ve
		obn=Create_Bullet(obj,x,y,z,xp,yp,zp,kfa,kft)
		MoveObjToCollection(col,obn)
		Set_ObjSize(obn,sx,sy,sz)
		pala.append(obn)
	return pala
########################################################################## 
# Explodes the given Object generate REAL Objects if real=1 
#	 
def Explode_Object_C(obj,col=0,kfa=1,kfi=10,ln=0,real=1,dep=2):
	fac=.5
	if kfa<0:
		kfa=Get_Actual_KF()
	if col==0:
		col=NewCollection('Bullets from Explode '+str(obj.name))
#x,y,z=obj.location 
	kft=kfa+kfi
	pala=list()
	sx,sy,sz=obj.dimensions*fac
	print(obj.dimensions/fac)
	print(obj.dimensions)
	cn=Generate_Spikes(obj,ln)
	sp=cn[0]
	ep=cn[1]
	lnx=len(sp)
	for i in range(0,lnx):
		x,y,z=sp[i]
		xp,yp,zp=ep[i]
		if real==1:
			obn=Create_Bullet_real(obj,col,x,y,z,xp,yp,zp,kfa,kft)
		else:
			obn=Create_Bullet(obj,x,y,z,xp,yp,zp,kfa,kft)
			MoveObjToCollection(col,obn)
		Set_ObjSize(obn,sx,sy,sz)
		pala.append([kft,obn])
		Ani_Hide_Object_at_KF(obn,1)
		Ani_Show_Object_at_KF(obn,kfa)
	if dep>1:
		cprint("Here with:"+str(pala))
		for i in pala:
			cprint(i)
			kft=i[0]
			obn=i[1]
			Explode_Object_C(obn,0,kft,kfi,ln,1,dep-1)
	Ani_Hide_Object_at_KF(obj,kfa)
	return pala
########################################################################## 
# Explodes the given Object generate REAL Objects if real=1 
#	 
def Explode_Selected_Objects(col=0,kfa=1,kfi=10,ln=0,real=1,dep=2):
	for obj in bpy.context.selected_objects:
		Explode_Object_C(obj,col,kfa,kfi,ln,real,dep)
####################################################### 
def Massive_attack_int(j,Co,sp=4,num=5,expl=0,lnx=0,Tol=1):
# Get Start Keyframe 
	sf=j[0]
# Target-Pos 
	txpo=j[1]
	typo=j[2]
	tzpo=j[3]
	cna=0
# For each Source do 
	for k in Co:
		cna+=1
# Choose first Object and get size 
		act=k
		obs=BB_Size(act)
# Target Randomization 1 mal Bullet-Size 
		tara=Tol*obs

# Startpos 
		spx,spy,spz=act.location
		obd=Geo_Point_Distance(txpo,typo,tzpo,spx,spy,spz)
# Länge der Explosions-Spikes berechnen		 
		if lnx==0:
			lnx=3*obd
#	sx,sy,sz=act.dimensions 
# Anzahl Frames ergibt sich aus Objekt-Größe und Abstand 
		fn=abs(obd/obs)
# Target-Frame berechnen 
		tf=sf+fn
# Play-Time in Frames abhängig von (sp)=Speed 
		fat=fn/sp
		col=NewCollection('Bullets from'+str(k))
		cnt=0
		Mya=list()
# Number of Bullets from each Source 
		for i in range(0, num):
#print("Looping Bullet "+str(i)+" from "+str(act)) 
# Target-Randomization 
			txp=r.uniform(-tara,+tara)+txpo
			typ=r.uniform(-tara,+tara)+typo
			tzp=r.uniform(-tara,+tara)+tzpo
#cprint("Target:"+str(txp)+","+str(typ)+","+str(tzp)+", Tar-Frame:"+str(tf)) 
			Myo=list()
			if expl==0:
				obj=Make_Linked(act,0)
				MoveObjToCollection(col,obj)
			else:
				obj=Copy_Object(act,col)
			Deselect_All()
			Set_Active_Object(obj)
#print("Append:"+str(obj)) 
			cnt+=1
			fsr=sf+((cnt-1)*fat)
			ftr=fsr+(fat*2)

			Myo=[obj,spx,spy,spz,txp,typ,tzp,fsr,ftr]
			Mya.append(Myo)
		cnt=0
		for Myo in Mya:
			cnt+=1
			print("Creating Bullets: "+str(cnt)+","+str(Myo))
			Make_Single_Bullet(Myo[0],Myo[1],Myo[2],Myo[3],Myo[4],Myo[5],Myo[6],Myo[7],Myo[8])
		if expl>0:
			for Myo in Mya:
				obj=Myo[0]
				spx=Myo[1]
				spy=Myo[2]
				spz=Myo[3]
				txp=Myo[4]
				typ=Myo[5]
				tzp=Myo[6]
				ftr=Myo[8]
#print(str(txp)+","+str(typ)+","+str(typ)) 
#Set_Object_Pos(obj,spx,spy,spz)	 
				opos=obj.location
				Set_Object_Pos(obj,txp,typ,tzp)
#Ani_Hide_Object_at_KF(obj,fsr) 
#Ani_Show_Object_at_KF(obj,ftr) 
				Explode_Object_C(obj,col,ftr,ftr+fat/2,lnx,1,expl)
				Restore_Object_Loc(obj,opos)
	return ftr

####################################################### 
# tol - Tolerance of Target Position 
def Massive_attack_E(j,Co,sp=4,num=5,expl=0,lnx=0,tol=5):
# Bullet Objects must be in A 
# Move Active Object and Slider to Start-Pos. 
	cprint("---------------------------------")
	va=Remember_Start()
# Remove first Element if equal with second 
	Co=Py_Check_First(Co)
	ftr=Massive_attack_int(j,Co,sp,num,expl,lnx,tol)
#print('Setting Loc.:'+str(txp)+","+str(typ)+","+str(tzp)+", Tar-Frame:"+str(ftr)) 
# Set Animation and RB-Frames: End-Frame to last frame+50 
	Set_Start_End_Frames(1,ftr+50)
# Reset Keyframe Interpolation Type 
	Restore_Start(va)
####################################################### 

########################################################################## 
# P1 - Collection with Bullet-Objects "GA" 
# # Select Bullet Objects and Move Active Object to Target-Pos. 
# Move Anim-Slider to start-Pos. 
def Get_Target_for_Canon():
	RB_Delete_Bakes()
# Get Starting Frame 
	tf=Get_Actual_KF()
# Get Target Point 
	act=Get_Active_Object()
	txp=act.location.x
	typ=act.location.y
	tzp=act.location.z
	ret=[tf,txp,typ,tzp]
	return ret
########################################################################## 	 
# Necessary preparations 
# set interpolation type 'LINEAR' or 'BEZIER' or "CIRC" 
def Remember_Start(Inter='BEZIER'):
	va=Start_Timer()
	vb=Remember_Keyframe_Interpolation(Inter)
	vc=Remember_Selected()
	return [va,vb,vc]

########################################################################## 	 
# Restore previous states 
def Restore_Start(vd):
	Restore_Selected(vd[2])
	Set_Keyframe_interpolation(vd[1])
	End_Timer(vd[0])
########################################################################## 
# https://docs.blender.org/api/current/bpy.types.Keyframe.html 
# [‘CONSTANT’, ‘LINEAR’, ‘BEZIER’, ‘SINE’, ‘QUAD’, ‘CUBIC’, ‘QUART’, ‘QUINT’, ‘EXPO’, ‘CIRC’, ‘BACK’, ‘BOUNCE’, ‘ELASTIC’], default ‘CONSTANT’ 
# Place Empty as Target, set Target-Keyframe, press LMB 
# Then use Bullet-Object for Starting-Pos. (Not Empty because Size of Object is used in Calc.) 
# BUA=Get_Target_for_Canon() 
# Make_massive_Attack_B(BUA,GA) 
# j - Target Pos.+Start-KF aus "Get_Target_for_Canon" 
# i - Collection mit Elementen (GA ..), sp=Speed 
def Make_massive_Attack_B(j,i,sp=4):
# Bullet Objects must be in A 
# Move Active Object and Slider to Start-Pos. 

# set interpolation type 'LINEAR' or 'BEZIER' or "CIRC" 
	va=Remember_Start()

# Get Start Point 
	act=Get_Active_Object()
	# Start-Keyframe
	sf=j[0]
	obs=BB_Size(i[0])
# Target-Pos 
	txp=j[1]
	typ=j[2]
	tzp=j[3]
	# Startpos
	spx,spy,spz=act.location
	#print("Start:"+str(spx)+","+str(spy)+","+str(spz)+", Tar-Frame:"+str(sf))
	obd=Geo_Point_Distance(txp,typ,tzp,spx,spy,spz)
# Anzahl Frames ergibt sich aus Objekt-Größe und Abstand 
	fn=abs(obd)/(2*obs)
	# Target-Frame berechnen
	tf=sf+fn
	#print("Target:"+str(txp)+","+str(typ)+","+str(tzp)+", Tar-Frame:"+str(tf))
# Play-Time in Frames 
	fat=fn/sp
# Target Randomization (4 mal Bullet-Size) 
	tara=2*obs
#sx,sy,sz=act.dimensions 
	cnt=0
	for obj in i:
		cnt+=1
		if cnt==1:
			continue
		Deselect_All()
		Set_Active_Object(obj)
		fsr=sf+((cnt-1)*fat)
		ftr=fsr+(fat*2)
		#print("fat:"+str(fat)+"  fsr: "+str(fsr)+"  ftr: "+str(ftr))
		#print('Setting Loc.:'+str(spx)+","+str(spy)+","+str(spz)+", Start-Frame:"+str(fsr))
		# Target-Randomization
		#ntx=r.uniform(-tara,+tara)+txp
		#print('Setting Loc.:'+str(txp)+","+str(typ)+","+str(tzp)+", Tar-Frame:"+str(ftr))
		Make_Single_Bullet(obj,spx,spy,spz,txp,typ,tzp,fsr,ftr)
	# Set Animation and RB-Frames: End-Frame to last frame+50
	Set_Start_End_Frames(1,ftr+50)
	# Reset Keyframe Interpolation Type
	Restore_Start(va)
	print('OK with:'+str(cnt))
########################################################################## 
# Here we generate the Objects a Clones from the Active Object 
# j - Target-Position, sp-Speed, num - Anzahl der Bullets 
# Uses: Massive_Attack_A2() 
def Massive_attack_C(j,sp=4,num=100):
# Bullet Objects must be in A 
# Move Active Object and Slider to Start-Pos. 

# set interpolation type 'LINEAR' or 'BEZIER' or "CIRC" 
	va=Remember_Start()

# Get Start Point 
	act=Get_Active_Object()
	sf=Get_Actual_KF()
	obs=BB_Size(act)
# Target-Pos 
	txp=j[1]
	typ=j[2]
	tzp=j[3]
	# Startpos
	spx,spy,spz=act.location
	print("Start:"+str(spx)+","+str(spy)+","+str(spz)+", Tar-Frame:"+str(sf))
	obd=Geo_Point_Distance(txp,typ,tzp,spx,spy,spz)
# Anzahl Frames ergibt sich aus Objekt-Größe und Abstand 
	fn=abs(obd)/(2*obs)
	# Target-Frame berechnen
	tf=sf+fn
	print("Target:"+str(txp)+","+str(typ)+","+str(tzp)+", Tar-Frame:"+str(tf))
# Play-Time in Frames 
	fat=fn/sp
# Target Randomization (4 mal Bullet-Size) 
	tara=4*obs
#sx,sy,sz=act.dimensions 
	cnt=0
	col=NewCollection('Bullets from'+str(act))
	for i in range(0, num):
		obj=Make_Linked(act,0)
		MoveObjToCollection(col,obj)
		cnt+=1
		if cnt==1:
			continue
		Deselect_All()
		Set_Active_Object(obj)
		fsr=sf+((cnt-1)*fat)
		ftr=fsr+(fat*2)
		print("fat:"+str(fat)+"  fsr: "+str(fsr)+"  ftr: "+str(ftr))
		print('Setting Loc.:'+str(spx)+","+str(spy)+","+str(spz)+", Start-Frame:"+str(fsr))
		# Target-Randomization
		ntx=r.uniform(-tara,+tara)+txp
		print('Setting Loc.:'+str(txp)+","+str(typ)+","+str(tzp)+", Tar-Frame:"+str(ftr))
		Make_Single_Bullet(obj,spx,spy,spz,txp,typ,tzp,fsr,ftr)
	# Set Animation and RB-Frames: End-Frame to last frame+50
	Set_Start_End_Frames(1,ftr+50)

	# Reset Keyframe Interpolation Type
	Restore_Start(va)
	print('OK with:'+str(cnt))

########################################################################## 
# Here we generate the Objects a Clones from the Objects in Collection A 
# j - Target-Position, 
# Co - Collection with Source Objects 
# sp-Speed, 
# num - Number of Bullets 
# expl - 0/1 - Switch on Explosion at target 
# dep - Recursive Explosion depth 
# len - distance the explosions will fly animated (len x object-size) 
# 
def Massive_attack_D(j,Co,sp=4,num=100,expl=0,lnx=10):
# Bullet Objects must be in A 
# Move Active Object and Slider to Start-Pos. 

	va=Remember_Start()
	cna=0
	Co=Py_Check_First(Co)
	for k in Co:
		cna+=1
	# Get Start Point
		act=k
		sf=Get_Actual_KF()
		obs=BB_Size(act)
	# Target-Pos
		txp=j[1]
		typ=j[2]
		tzp=j[3]
		# Startpos
		spx,spy,spz=act.location
		cprint("Start:"+str(spx)+","+str(spy)+","+str(spz)+", Tar-Frame:"+str(sf))
		#time.sleep(10)
		obd=Geo_Point_Distance(txp,typ,tzp,spx,spy,spz)
	# Anzahl Frames ergibt sich aus Objekt-Größe und Abstand
		fn=abs(obd)/(2*obs)
		# Target-Frame berechnen
		tf=sf+fn
		#print("Target:"+str(txp)+","+str(typ)+","+str(tzp)+", Tar-Frame:"+str(tf))
		#time.sleep(10)
	# Play-Time in Frames
		fat=fn/sp
	# Target Randomization (1 mal Bullet-Size)
		tara=1*obs
	#sx,sy,sz=act.dimensions
		col=NewCollection('Bullets from'+str(k))
		cnt=0
		Mya=list()
		for i in range(0, num):
			Myo=list()
			obj=Make_Linked(act,0)
			Deselect_All()
			Set_Active_Object(obj)
			MoveObjToCollection(col,obj)
			Myo.append(obj)
			cnt+=1
			#if cnt==1:
				#continue
			fsr=sf+((cnt-1)*fat)
			ftr=fsr+(fat*2)
			Myo.append([obj,spx,spy,spz,txp,typ,tzp,fsr,ftr])
			#print("fat:"+str(fat)+"  fsr: "+str(fsr)+"  ftr: "+str(ftr))
			#print('Setting Loc.:'+str(spx)+","+str(spy)+","+str(spz)+", Start-Frame:"+str(fsr))
			# Target-Randomization
			#ntx=r.uniform(-tara,+tara)+txp
			#print('Setting Loc.:'+str(txp)+","+str(typ)+","+str(tzp)+", Tar-Frame:"+str(ftr))

			Make_Single_Bullet(obj,spx,spy,spz,txp,typ,tzp,fsr,ftr)
			if expl>0:
				opos=obj.location
				#Set_Object_Pos(obj,txp,typ,tzp)
				sec=Explode_Object_B(obj,col,ftr,ftr+fat,lnx,1,expl)
				#Restore_Object_Loc(obj,opos)
	# Set Animation and RB-Frames: End-Frame to last frame+50
	Set_Start_End_Frames(1,ftr+50)
	# Reset Keyframe Interpolation Type
	Restore_Start(va)
	print('OK with:'+str(cnt))
########################################################################## 
########################################################################## 
# set interpolation type 'LINEAR' or 'BEZIER' or "CIRC" 
# and return original value 
def Remember_Keyframe_Interpolation(set='BEZIER'):
	keyInterp = Get_Keyframe_interpolation()
	Set_Keyframe_interpolation(set)
	return keyInterp

########################################################################## 
def Array_Remove_Doubles(Ara):
	new=[]
	for i in Ara:
		if i not in new:
			new.append(i)
	return new
########################################################################## 
########################################################################## 


########################################################################## 
# Verschiebe Objekte in X-Richtung 
def Move_selected_ObjectX(va):
	for obj in bpy.context.selected_objects:
		obj.location.x+=va
########################################################################## 
# Verschiebe Objekte in Y-Richtung 
def Move_selected_ObjectY(va):
	for obj in bpy.context.selected_objects:
		obj.location.y+=va
########################################################################## 
# Verschiebe Objekte in Z-Richtung 
def Move_selected_ObjectZ(va):
	for obj in bpy.context.selected_objects:
		obj.location.z+=va
########################################################################## 
# Setze Position von selektierten Objekten in X-Richtung 
def Move_selected_Object_to_X(va):
	for obj in bpy.context.selected_objects:
		obj.location.x=va
########################################################################## 
# Setze Position von selektierten Objekten in Y-Richtung 
def Move_selected_Object_to_Y(va):
	for obj in bpy.context.selected_objects:
		obj.location.y=va
########################################################################## 
# Setze Position von selektierten Objekten in Z-Richtung 
def Move_selected_Object_to_Z(va):
	for obj in bpy.context.selected_objects:
		obj.location.z=va
########################################################################## 
def Move_selected_Object_To(x,y,z):
	for obj in bpy.context.selected_objects:
		obj.location.x=x
		obj.location.y=y
		obj.location.z=z
########################################################################## 
def Set_Object_Pos(obj,x,y,z):
	obj.location.x=x
	obj.location.y=y
	obj.location.z=z
########################################################################## 
# w - maximaler Rotationswinkel 
def Random_Rotate_Object(n,w=360):
	n.rotation_euler = (0, 0, 0)
	xr = r.uniform(0,w)
	yr = r.uniform(0,w)
	zr = r.uniform(0,w)
	n.rotation_euler = (xr,yr,zr)
########################################################################## 
def RandomRotate_selected(w=360):
	for n in bpy.context.selected_objects:
		Random_Rotate_Object(n,w)
########################################################################## 
def Rotate_Selected_To(X,Y,Z):
	for obj in bpy.context.selected_objects:
		obj.rotation_euler.x = m.radians(X)
		obj.rotation_euler.y = m.radians(Y)
		obj.rotation_euler.z = m.radians(Z)
########################################################################## 
# Drehe selektierte Objekte in X-Richtung auf va Grad 
def Rotate_selected_ObjectX_To(va):
	for obj in bpy.context.selected_objects:
		obj.rotation_euler.x = m.radians(va)
########################################################################## 
# Drehe selektierte Objekte in Y-Richtung auf va Grad 
def Rotate_selected_ObjectY_To(va):
	for obj in bpy.context.selected_objects:
		obj.rotation_euler.y = m.radians(va)
########################################################################## 
# Drehe selektierte Objekte in Z-Richtung auf va Grad 
def Rotate_selected_ObjectZ_To(va):
	for obj in bpy.context.selected_objects:
		obj.rotation_euler.z = m.radians(va)
########################################################################## 
# Drehe selektierte Objekte in X-Richtung um va Grad 
def Rotate_selected_ObjectX(va):
	for obj in bpy.context.selected_objects:
		obj.rotation_euler.x += m.radians(va)
########################################################################## 
# Drehe selektierte Objekte in Y-Richtung um va Grad 
def Rotate_selected_ObjectY(va):
	for obj in bpy.context.selected_objects:
		obj.rotation_euler.y += m.radians(va)
########################################################################## 
# Drehe selektierte Objekte in Z-Richtung um va Grad 
def Rotate_selected_ObjectZ(va):
	for obj in bpy.context.selected_objects:
		obj.rotation_euler.z += m.radians(va)
########################################################################## 
# Drehe selektierte Objekte in X-Richtung auf va Grad 
def Set_Rotate_selected_ObjectX(va):
	for obj in bpy.context.selected_objects:
		obj.rotation_euler.x = m.radians(va)
########################################################################## 
# Drehe selektierte Objekte in Y-Richtung auf va Grad 
def Set_Rotate_selected_ObjectY(va):
	for obj in bpy.context.selected_objects:
		obj.rotation_euler.y = m.radians(va)
########################################################################## 
# Drehe selektierte Objekte in Z-Richtung auf va Grad 
def Set_Rotate_selected_ObjectZ(va):
	for obj in bpy.context.selected_objects:
		obj.rotation_euler.z = m.radians(va)
########################################################################## 
def Rotate_selected_ObjectXS(obj,va):
	yr=obj.rotation_euler.y
	zr=obj.rotation_euler.z
	obj.rotation_euler.y=0
	obj.rotation_euler.z=0
	obj.rotation_euler.x += m.radians(va)
	obj.rotation_euler.y=yr
	obj.rotation_euler.z=zr
########################################################################## 
# Drehe selektierte Objekte in X-Richtung um va Grad 
def Rotate_selected_ObjectXS(va):
	for obj in bpy.context.selected_objects:
		Rotate_selected_ObjectXS(obj,va)

########################################################################## 
########################################################################## 
# 
# ReCenter Geometry 
# 
########################################################################## 
########################################################################## 
def Geometry_to_Origin(ref = None):
	objref = Get_Object_Any(ref)
	if objref is not None:
		Select_Object(objref)
	bpy.ops.object.origin_set(type='GEOMETRY_ORIGIN')
########################################################################## 

########################################################################## 
def Origin_to_Geometry(ref = None):
	objref = Get_Object_Any(ref)
	if objref is not None:
		Select_Object(objref)
	bpy.ops.object.origin_set(type='ORIGIN_GEOMETRY')
########################################################################## 

########################################################################## 
def Origin_to_Cursor(ref = None):
	objref = Get_Object_Any(ref)
	if objref is not None:
		Select_Object(objref)
	bpy.ops.object.origin_set(type='ORIGIN_CURSOR')
########################################################################## 

########################################################################## 
# cent= 'ORIGIN_GEOMETRY','GEOMETRY_ORIGIN','ORIGIN_CURSOR','ORIGIN_CENTER_OF_MASS','ORIGIN_CENTER_OF_VOLUME' 
def Origin_to_Any(cent='ORIGIN_CENTER_OF_MASS'):
	bpy.ops.object.origin_set(type=cent, center='MEDIAN')
########################################################################## 
def Origin_to_Center():
	bpy.ops.object.origin_set(type='ORIGIN_CENTER_OF_MASS', center='MEDIAN')
########################################################################## 
def Origin_to_Geometry_fast():
	bpy.ops.object.origin_set(type='ORIGIN_GEOMETRY', center='MEDIAN')

########################################################################## 
def ReCenterGeo(obj,hg):
	myobj = bpy.data.objects[obj.name]
	Origin_to_Geometry()
	myobj.location=(0,0,hg)
	return myobj
########################################################################## 
########################################################################## 
# 
# Cube to Plank 
# 
########################################################################## 
########################################################################## 
# Make a Plank out of a cube 
def cube2plank(obj,sz,psz):
# Modify Cube 1 to Plank (1,3,5,7) 
	obj.data.vertices[0].co.z -= sz
	obj.data.vertices[2].co.z -= sz

	obj.data.vertices[4].co.z -= sz
	obj.data.vertices[6].co.z -= sz

	for a in range(0,4):
		obj.data.vertices[a].co.x -= psz
		obj.data.vertices[a+4].co.x += psz
########################################################################## 
########################################################################## 
########################################################################## 
# 
# Keyfile Subs 
# 
########################################################################## 
########################################################################## 
########################################################################## 
def Select_KF_Between(obj,start=1,ens=250):
	if obj is None:
		obj =Get_Active_Object()        #active object
	action = obj.animation_data.action   #current action

	for i in action.fcurves:
		for x in i.keyframe_points:
			if x.co[0] > start and x.co[0] < end: #check greater than/less than marker frames
				x.select_control_point=True #deselect if in between markers
			else:
				x.select_control_point=False

########################################################################## 
# Return list with all Keyframes from selected Objects 
#  print ("{} {}".format("first keyframe:", keys[0])) 
#  print ("{} {}".format("last keyframe:", keys[-1])) 
def Get_all_keyframes_selected():
	all= bpy.context.selected_objects
# testen ob leer 
	if all:
		keys=Get_all_keyframes(all)
	return keys

########################################################################## 
# Return keyframes of all objects in object list 
# Resultat Liste mit Nummern der KF: [1,21,59] 
def Get_all_keyframes(obj_list):
	keyframes = []
	for obj in obj_list:
		anim = obj.animation_data
		if anim is not None and anim.action is not None:
			for fcu in anim.action.fcurves:
				for keyframe in fcu.keyframe_points:
					x, y = keyframe.co
					if x not in keyframes:
						keyframes.append((math.ceil(x)))
	return keyframes
############################################################################## 
def Show_all_KF_Selected():
	objs = bpy.context.selected_objects

# normal fcurves 
	for obj in objs:
		print('-'*20 + ' normal fcurves ' + '-'*20)
		if obj.animation_data == None:
			continue
		print(obj.animation_data.action.name)
		fcurves = obj.animation_data.action.fcurves
		for fc in fcurves:
			print('group : %s \t index : %s' % (fc.data_path, fc.array_index))
			for key in fc.keyframe_points:
				print('frame # : %s \t value : %s' % (key.co[0], key.co[1]))

# shape keys 
	for obj in objs:
		print('-'*20 + ' shape keys fcurves ' + '-'*20)
		if obj.data.shape_keys:
			print(obj.data.shape_keys.name)
			for key in obj.data.shape_keys.key_blocks:
# this can be used to insert or delete a keyframe but not modify 
				print('key name : %s \t value : %s' % (key.name, key.value))
			fcurves = obj.data.shape_keys.animation_data.action.fcurves
			for fc in fcurves:
# this can be used to modify an existing keyframe but not directly reference the key name 
				print('group : %s \t index : %s' % (fc.data_path, fc.array_index))
				for key in fc.keyframe_points:
					print('frame # : %s \t value : %s' % (key.co[0], key.co[1]))


########################################################################## 
def Del_all_KF_Selected():
	context = bpy.context
	for ob in context.selected_objects:
		ob.animation_data_clear()
########################################################################## 
# Delete ALL specified Keyframes from ALL selected Objects 
# tp = 1  : Del Location KF 
# tp = 2  : Del Rotation KF 
# tp = 4  : Del Scale KF 
def Del_all_KF_Sel(tp=7):
	for obj in bpy.context.selected_objects:
		Del_Rot_loc_scale_KF(obj,tp)
########################################################################## 
# Delete only Keyframe Nr.num from ALL selected Objects 
# tp = 1  : Del Location KF 
# tp = 2  : Del Rotation KF 
# tp = 4  : Del Scale KF 
def Del_KF_number_from_Sel(num,tp=7):
	for obj in bpy.context.selected_objects:
		Del_Rot_loc_scale_num_KF(obj,num,tp)
########################################################################## 
# Delete only Keyframe Nr.num from ALL selected Objects 
# tp = 1  : Del Location KF 
# tp = 2  : Del Rotation KF 
# tp = 4  : Del Scale KF 
def Del_KF_actual_from_Sel(tp=7):
	num=Get_Actual_KF()
	for obj in bpy.context.selected_objects:
		Del_Rot_loc_scale_num_KF(obj,num,tp)

########################################################################## 
# Speed - Speed with which the ball rotates 
# Keyf - Last Keyframe 
########################################################################## 
# tp = 1  : Del Location KF 
# tp = 2  : Del Rotation KF 
# tp = 4  : Del Scale KF 
# remove_types = ["location", "scale", "rotation"] 
# To remove only y axis Loc, Rot and Scale also test for the Fcurve.array_index property which is 0, 1, 2 for x, y, z respectively. 
def Del_Rot_loc_scale_KF(obj,tp=7):
	rtp=list()
	if IfBit(1,tp):
		rtp.append('location')
	if IfBit(2,tp):
		rtp.append('rotation')
	if IfBit(3,tp):
		rtp.append('scale')
	if IfBit(4,tp):
		rtp.append('rigid_body.kinematic')
	if IfBit(5,tp):
		rtp.append('rigid_body.enabled')
	ad = obj.animation_data
	if ad:
		action = ad.action
		if action:
			remove_types = rtp
# select all that have datapath above 
			fcurves = [fc for fc in action.fcurves
					for type in remove_types
					if fc.data_path.startswith(type)
					]
# remove fcurves 
			while(fcurves):
				fc = fcurves.pop()
				action.fcurves.remove(fc)

########################################################################## 
# Speed - Speed with which the ball rotates 
# Keyf - Last Keyframe 
########################################################################## 
# tp = 1  : Del Location KF 
# tp = 2  : Del Rotation KF 
# tp = 4  : Del Scale KF 
# remove_types = ["location", "scale", "rotation"] 
# num=Frame-Nummer die gelöscht werden soll 
# To remove only y axis Loc, Rot and Scale also test for the Fcurve.array_index property which is 0, 1, 2 for x, y, z respectively. 
# Deletes too much! Needs Repair. 
# See 
def Del_Rot_loc_scale_num_KF(obj,num,tp=7):
	if IfBit(1,tp):
		obj.keyframe_delete('location',-1,frame=num)
	if IfBit(2,tp):
		obj.keyframe_delete('rotation_euler',-1,frame=num)
	if IfBit(3,tp):
		obj.keyframe_delete('scale',-1,frame=num)
	if IfBit(4,tp):
		obj.keyframe_delete('rigid_body.kinematic',-1,frame=num)
	if IfBit(5,tp):
		obj.keyframe_delete('rigid_body.enabled',-1,frame=num)

########################################################################## 
# Setzt den Keyframe-Zeiger in Blender auf num 
def Set_Actual_KF(num=1):
	bpy.context.scene.frame_set(num)
########################################################################## 
def Get_Actual_KF():
	cf= bpy.context.scene.frame_current
	return cf
########################################################################## 
def Set_LocRot_Keyframe_selected():
	fn=Get_Actual_KF()
	for obj in bpy.context.selected_objects:
		Keyframe_LR(obj,fn)
########################################################################## 
def Set_Location_KF_Obj(obj,kf=-1000):
	if kf==-1000:
		kf=Get_Actual_KF()
	#Set_Actual_KF(kf)
	obj.keyframe_insert(data_path="location", frame=kf)
########################################################################## 
def Set_Loc_Keyframe_selected():
	fn=Get_Actual_KF()
	for obj in bpy.context.selected_objects:
		#Set_Actual_KF(fn)
		obj.keyframe_insert(data_path="location", frame=fn)
########################################################################## 
def Set_Rot_Keyframe_selected():
	fn=Get_Actual_KF()
	for obj in bpy.context.selected_objects:
		#Set_Actual_KF(fn)
		obj.keyframe_insert(data_path="rotation_euler", frame=fn)
########################################################################## 
def Set_Scale_Keyframe_selected():
	fn=Get_Actual_KF()
	for obj in bpy.context.selected_objects:
		obj.keyframe_insert(data_path="scale", frame=fn)
########################################################################## 
# Löscht all Loc/Rot Keyframes der akt. CAM 
def Del_actCam_KF_all():
#cam = bpy.data.objects["Camera"] 
	cam=Get_Active_Cam()
	Del_Rot_loc_scale_KF(cam,3)
########################################################################## 
# Löscht all Loc/Rot Keyframes der akt. CAM im akt. Keyframe 
def Del_actCam_KF_sel():
#cam = bpy.data.objects["Camera"] 
	cam=Get_Active_Cam()
	num=Get_Actual_KF()
	Del_Rot_loc_scale_num_KF(cam,num,3)
########################################################################## 
# Set Loc/Rot Keyframes der akt. CAM im akt. Keyframe 
def Set_KF_RL_actCam_sel():
	cam=Get_Active_Cam()
	num=Get_Actual_KF()
	Keyframe_LR(cam,num)
########################################################################## 
# cam = bpy.data.objects["Camera"] 
# Keyframe Object 
def Keyframe_LR(obj,fn):
	#Set_Actual_KF(fn)
	obj.keyframe_insert(data_path="rotation_euler", frame=fn)
	obj.keyframe_insert(data_path="location", frame=fn)
########################################################################## 
def Camera_Keyframe_LR(fn):
#cam = bpy.data.objects["Camera"] 
	cam=Get_Active_Cam()
	Keyframe_LR(cam,fn)
########################################################################## 
def Camera_Setloc(xp,yp,zp):
#myo= bpy.data.objects["Camera"] 
	myo=Get_Active_Cam()
	Setloc(myo,xp,yp,zp)
########################################################################## 
def Set_Cam_ClipEnd(e=1e6):
	myo=Get_Active_Cam()
	myo.data.clip_end=e
########################################################################## 
########################################################################## 
# 
# Do with CAMERA 
# 
########################################################################## 
########################################################################## 
def Get_Active_Cam():
	cam = bpy.context.scene.camera
	if cam is None:
		Cameras=NewCollection("Cameras")
		cam=AddCamera("Camera")
		MoveObjToCollection(Cameras,cam)
#print("no scene camera in Get_Active_Cam()") 
	return(cam)
########################################################################## 
def Set_Active_Cam():
	scene = bpy.context.scene
	currentcam = bpy.context.scene.camera
	setcam = False

	for ob in scene.objects:
		if ob.type == 'CAMERA':
			if ob == currentcam:
				setcam = True
			elif setcam:
				bpy.context.scene.camera = ob
				break

	if currentcam == bpy.context.scene.camera:
		for ob in scene.objects:
			if ob.type == 'CAMERA':
				bpy.context.scene.camera = ob
				break
########################################################################## 
def Set_Active_Cam_ID(ob):
	bpy.context.scene.camera = ob
########################################################################## 
def Set_Active_Cam_Name(Name='CAMERA'):
	for ob in scene.objects:
			if ob.name == Name:
				bpy.context.scene.camera = ob
				break
########################################################################## 
# X=0, Y=1, Z=2 
def Active_Camera_turn_Any(grad,dir=0):
	cam=Get_Active_Cam()
	Camera_turn_Any(cam,grad,dir)
########################################################################## 
def Active_Camera_turn_X(Grad):
	Active_Camera_turn_Any(Grad,0)
########################################################################## 
def Active_Camera_turn_Y(Grad):
	Active_Camera_turn_Any(Grad,1)
########################################################################## 
def Active_Camera_turn_Z(Grad):
	Active_Camera_turn_Any(Grad,2)
########################################################################## 
# Grad - Winkel der Drehung 
# dir: X=0, Y=1, Z=2 
# cam - ID of Camera 
def Camera_turn_Any(cam,grad=45,dir=0):
	Euler=m.radians(grad)
	yrot=cam.rotation_euler[dir]
	cam.rotation_euler[dir] = yrot+Euler
########################################################################## 
def Camera_turn_X(cam,Grad=45):
	Camera_turn_Any(cam,Grad,0)
########################################################################## 
def Camera_turn_Y(cam,Grad=45):
	Camera_turn_Any(cam,Grad,1)
########################################################################## 
def Camera_turn_Z(cam,Grad=45):
	Camera_turn_Any(cam,Grad,2)

########################################################################## 
########################################################################## 
# 
# Set VIDEO Parameters 
# 
########################################################################## 
########################################################################## 
def Set_Render_Resolution(x=3840,y=2160):
	scene=Get_Current_Scene()
	# Set render resolution
	scene.render.resolution_x = x
	scene.render.resolution_y = y
	scene.render.resolution_percentage = 100
########################################################################## 
def Set_Video_Parameter(x=3840,y=2160):
	#Prepare Video Settings
	nua=r.randint(0,9999)
	num='{0:06}'.format(nua)
	bpy.context.scene.render.image_settings.file_format = 'FFMPEG'
	bpy.context.scene.render.ffmpeg.format = 'MPEG4'
	bpy.context.scene.render.ffmpeg.constant_rate_factor = 'HIGH'
	bpy.context.scene.render.ffmpeg.ffmpeg_preset = 'GOOD'
	bpy.context.scene.render.filepath = "//XY_"+str(num)+".mp4"
	Set_Render_Resolution(x,y)
########################################################################## 
########################################################################## 
# 
# 
# 
########################################################################## 
########################################################################## 
# Set Shading for active Object 
# Flat Shading: False, SMooth Shading - True 
def Set_Shading(Pa=True):
	bpy.context.object.data.polygons.foreach_set('use_smooth',  [Pa] * len(bpy.context.object.data.polygons))
	bpy.context.object.data.update()

########################################################################## 
def genRandVec(pLen):
#setup random translation vector 
	t = [r.random() - 0.5 for x in range(3)]
# normalize the translation vector 
	t_len = m.pow(m.pow(t[0], 2) + pow(t[1], 2) + pow(t[2], 2), 0.5)
	t = [x / t_len for x in t]
# multiply it with the length 
	t = [x * pLen for x in t]
	return t
########################################################################## 
#obj          the input object 
#t_amount     the maximum amount of translation 
#t_var        the amount of variance in the translation [0 ... 1] 
#r_amount     the maximum amount of rotation 
#r_var        the amount of variance in the rotation[0 ... 1] 
########################################################################## 
def RNDLocRot(obj, t_amount, t_var, r_amount, r_var):
	import random as r
	t_rand = r.uniform(1-t_var, 1)
	t = genRandVec(t_amount * t_rand)
	obj.location = (t[0] + obj.location.x, t[1] + obj.location.y, t[2] + obj.location.z)
	r_rand = r.uniform(1-r_var, 1)
	r = genRandVec(r_amount * r_rand)
# because radians are confusing 
	r = [x*pi/180 for x in r]
	obj.rotation_euler = [obj.rotation_euler[0] + r[0], obj.rotation_euler[1] + r[1], obj.rotation_euler[2] + r[2]]
########################################################################## 
# https://docs.blender.org/api/2.80/bpy.types.PreferencesEdit.html?#bpy.types.PreferencesEdit.keyframe_new_interpolation_type 
# [‘CONSTANT’, ‘LINEAR’, ‘BEZIER’, ‘SINE’, ‘QUAD’, ‘CUBIC’, ‘QUART’, ‘QUINT’, ‘EXPO’, ‘CIRC’, ‘BACK’, ‘BOUNCE’, ‘ELASTIC’], default ‘CONSTANT’ 
def Set_Keyframe_interpolation(de='LINEAR'):
	bpy.context.preferences.edit.keyframe_new_interpolation_type=de
########################################################################## 
def Get_Keyframe_interpolation():
	de=bpy.context.preferences.edit.keyframe_new_interpolation_type
	return de
########################################################################## 
def Ani_Get_Start_Frame():
	scn = bpy.context.scene
	sf = scn.frame_start
	return sf
########################################################################## 
def Ani_Set_Start_Frame(sf=1):
	scn = bpy.context.scene
	scn.frame_start=sf
	return sf
########################################################################## 
def Ani_Get_End_Frame():
	scn = bpy.context.scene
	ef = scn.frame_end
	return ef
########################################################################## 
def Ani_Set_End_Frame(ef=250):
	scn = bpy.context.scene
	scn.frame_end=ef
	return sf
########################################################################## 
def RB_Ani_End_Kinematic_at_KF(obj,kf):
	okf=Get_Actual_KF()
	Set_Actual_KF(kf)
	obj.rigid_body.kinematic = True
	obj.keyframe_insert(data_path='rigid_body.kinematic', frame=kf)
	Set_Actual_KF(kf+1)
	obj.rigid_body.kinematic = False
	obj.keyframe_insert(data_path='rigid_body.kinematic', frame=kf+1)
	Set_Actual_KF(okf)
########################################################################## 
# - Show = t/f  - false-> Show object, true -> Hide Object 
# ho - 1/0 Do NOT Hide in Viewport if 1 
	#osa=bpy.data.objects[obj.name].hide_viewport
	#osb=bpy.data.objects[obj.name].hide_render
	#bpy.data.objects[obj.name].hide_viewport=False
	#bpy.data.objects[obj.name].hide_render=False
def Ani_View_Object_at_KF(obj,sho=False,kf=-99,ho=0):
	okf=Get_Actual_KF()
	if kf==-99:
		mkf=okf
	else:
		mkf=kf
	if sho==True:
		shoi=False
		#obj.hide_viewport=False
		#obj.hide_render=False
		#Set_Active_Object(obj)
	else:
		shoi=True
	mki=mkf-1
	Set_Actual_KF(mkf)
	if ho==0:
		obj.hide_viewport=sho
		obj.keyframe_insert(data_path="hide_viewport",frame=mkf)

	obj.hide_render = sho
	obj.keyframe_insert(data_path="hide_render",frame=mkf)

	Set_Actual_KF(mki)

	if ho==0:
		obj.hide_viewport=shoi
		obj.keyframe_insert(data_path="hide_viewport",frame=mki)

	obj.hide_render = shoi
	obj.keyframe_insert(data_path="hide_render",frame=mki)

	if ho==0:
		obj.hide_viewport=False

	obj.hide_render = False
	Set_Actual_KF(okf)

########################################################################## 
# - Show = t/f  - false-> Show object, true -> Hide Object 
# ho - 1/0 Do NOT Hide in Viewport if 1 
def Ani_View_Selected_Objects_at_KF(sho=False,kf=-99,ho=0):
	oa=Remember_Selected()
	selo=bpy.context.selected_objects
	for obj in selo:
		Deselect_All()
		Ani_View_Object_at_KF(obj,sho,kf,ho)
	Restore_Selected(oa)
########################################################################## 
# i -> GA Collection A 
# - Show = t/f  - false-> Show object, true -> Hide Object 
# ho - 1/0 Do NOT Hide in Viewport if 1 
def Ani_View_for_A_Objects_at_KF(i,sho=False,kf=-99,ho=0):
	oa=Remember_Selected()
	for obj in i:
		Deselect_All()
		Ani_View_Object_at_KF(obj,sho,kf,ho)
	Restore_Selected(oa)
########################################################################## 

########################################################################## 
# If kf=-99 then we use the current Keyframe 
def Ani_Show_Object_at_KF(obj,kf=-99,ho=0):
	if kf==-99:
		mkf=Get_Actual_KF()
	else:
		mkf=kf
	Ani_View_Object_at_KF(obj,False,mkf,ho)
	return kf
########################################################################## 
# ho - 1/0 Do NOT Hide in Viewport if 1 
def Ani_Hide_Object_at_KF(obj,kf,ho=0):
	Ani_View_Object_at_KF(obj,True,kf,ho)
########################################################################## 
def Outl_Show_State(show=1):
	# Set the area to the outliner
	area = bpy.context.area
	old_type = area.type
	area.type = 'OUTLINER'

	# Select all objects in the current scene
	for obj in bpy.context.scene.objects:
		obj.select_set(Show)
		if show==1:
			bpy.ops.object.hide_view_clear()
		else:
			bpy.ops.object.hide_view_set()
	# Reset the area
	area.type = old_type
########################################################################## 
def Outl_Hide_All():
	Outl_Show_State(0)
########################################################################## 
#bpy.ops.object.hide_view_set() 
#bpy.ops.object.hide_render_clear_all() 
#bpy.ops.object.hide_view_set(unselected=False) 
# 
def Outl_Show_All():
	Outl_Show_State(1)
########################################################################## 	 
# Usage: get_hidden() 
# prints the name of hidden objects 
def Print_Hidden():

	context = bpy.context

	with_eye = []
	with_monitor = []
	with_eye_and_monitor = []

	for o in context.view_layer.objects:

		if not o.hide_viewport and not o.visible_get():
			with_eye.append(o)
			continue

		if o.hide_viewport:
			o.hide_viewport = False # toggle to test visibility

			if o.visible_get():
				with_monitor.append(o)

			else:
				with_eye_and_monitor.append(o)

			o.hide_viewport = True # toggle back

	if with_eye:
		print(
			"With eye only:\n",
			[o.name for o in with_eye])

	if with_monitor:
		print(
			"With monitor only:\n",
			[o.name for o in with_monitor])

	if with_eye_and_monitor:
		print(
			"With eye and monitor:\n",
			[o.name for o in with_eye_and_monitor])

########################################################################## 
# Select Particles and Call this: 
def TwoFrameRNDMovement():
# get scene variables 
	sel = bpy.context.selected_objects
	scn = bpy.context.scene
	startFrame = Ani_Get_Start_Frame()
	keyInterp = Get_Keyframe_interpolation()
# set interpolation type 
	Set_Keyframe_interpolation('LINEAR')
# counter 
	i = 0
	for obj in sel:
		RB_Add_Object(obj,1)
		i += 1
		#print(str(i) + " / " + str(len(sel)))
		obj.keyframe_insert(data_path='location', frame=startFrame)
		obj.keyframe_insert(data_path='rotation_euler', frame=startFrame)
		RNDLocRot(obj, 4.2, 1, 2, 1)
		obj.keyframe_insert(data_path='location', frame=startFrame+2)
		obj.keyframe_insert(data_path='rotation_euler', frame=startFrame+2)
		RB_Ani_End_Kinematic_at_KF(obj,startFrame+1)
# set interpolation type back 
	Set_Keyframe_interpolation(keyInterp)
#Switch Gravity off 
	bpy.context.scene.use_gravity = False


########################################################################## 
def RandRotate(Speed,Keyf):
	mkf=Keyf/2
	nkf=Keyf/8
	for newBall in bpy.context.selected_objects:
		p1=nkf*2
		p2=mkf+p1
		mymkf=r.uniform(p1,p2)
		newBall.rotation_euler = (0, 0, 0)
		newBall.keyframe_insert(data_path="rotation_euler", frame=1)
		xr = r.uniform(0,Speed*2)-Speed
		yr = r.uniform(0,Speed*2)-Speed
		zr = r.uniform(0,Speed*2)-Speed
		newBall.rotation_euler = (xr,yr,zr)
		newBall.keyframe_insert(data_path="rotation_euler", frame=mymkf)
		newBall.rotatioscan_euler = (0, 0, 0)
		newBall.rotation_euler = (0, 0, 0)
		newBall.keyframe_insert(data_path="rotation_euler", frame=Keyf)

########################################################################## 
def RandMove(Speed,Keyf):
	mkf=Keyf/2
	nkf=Keyf/8
	for newBall in bpy.context.selected_objects:
		p1=nkf*2
		p2=mkf+p1
		mymkf=r.uniform(p1,p2)

		xol=newBall.location.x
		yol=newBall.location.y
		zol=newBall.location.z

		newBall.keyframe_insert(data_path="location", frame=1)

		xr =xol+ r.uniform(0,Speed*2)-Speed
		yr =yol+ r.uniform(0,Speed*2)-Speed
		zr =zol+ r.uniform(0,Speed*2)-Speed
		newBall.location = (xr,yr,zr)
		newBall.keyframe_insert(data_path="location", frame=mymkf)
		newBall.location = (xol,yol,zol)
		newBall.keyframe_insert(data_path="location", frame=Keyf)

########################################################################## 
# Reveal all render objects by setting the hide render flag 
def Flags_Clear_Hide_Render():
	bpy.ops.object.hide_render_clear_all()
########################################################################## 
#region MATERIALS 
########################################################################## 
# Material 
########################################################################## 
# Load Texture Image into a Material 
def material_for_texture(fname):
	img = bpy.data.images.load(fname)

	tex = bpy.data.textures.new(fname, 'IMAGE')
	tex.image = img

	mat = bpy.data.materials.new(fname)
	mat.texture_slots.add()
	ts = mat.texture_slots[0]
	ts.texture = tex
	ts.texture_coords = 'ORCO'
	return mat
########################################################################## 
########################################################################## 
#fname = "/var/tmp/blender/mohawk-seal0001.png" 
def Do_Load_Material(fname):
	obj = bpy.context.active_object
	mat = material_for_texture(fname)
	if len(obj.data.materials)<1:
		obj.data.materials.append(mat)
	else:
		obj.data.materials[0] = mat
	set_UV_editor_texture(obj.data)


########################################################################## 
def Get_Material_Slot_0(object):
	if not object.material_slots.values():
		name = object.name
		material = bpy.data.materials.new(name)
		object.data.materials.append(material)
	else:
		material = object.material_slots[0].material
	return material
########################################################################## 
# m 0 metallic 0..1, r - roughness 0...1 
def Mat_Create(object,r=0,g=0,b=0,a=0,m=0,ro=0):
	material=Get_Material_Slot_0(object)
	a=0
	material.diffuse_color = (r, g, b,a)
	material.metallic=m
	material.roughness=ro
########################################################################## 
def Add_Random_Colour(obj,m=0):
# generate random colors (float values 0.00 - 0.99) 
	re = r.random()
	g = r.random()
	b = r.random()
	if m>0:
		ro=m/10
	else:
		ro=1
	Mat_Create(obj,re,g,b,0,m,ro)
########################################################################## 

########################################################################## 
# Wenn m=1 dann Metallic und roughness=0 
def Set_Random_Colours(m=0):
	for obj in bpy.context.selected_objects:
		Add_Random_Colour(obj,m)
########################################################################## 
def set_UV_editor_texture(mesh):
# set the image for the face.tex layer on all the faces 
#so we have a rough idea of what the mesh will look like 
#in the 3D view's Texture render mode 

# load the mesh data into a bmesh object 
	bm = bmesh.new()
	bm.from_mesh(mesh)

	bm.faces.ensure_lookup_table()

# Get the "tex" layer for the first UV map 
# If you don't already have a UV map, why are you even calling this function? 
	tex_layer = bm.faces.layers.tex[mesh.uv_layers[0].name]

	for i in range(len(bm.faces)):

# figure out which material this face uses 
		mi = bm.faces[i].material_index
		mat = mesh.materials[mi]

# Assume that we want to use the image from the first texture slot; 
# and assume that the material has a texture in that first slot; 
# and assume that the texture is an image texture instead of a procedural texture. 
# if any of several assumptions are wrong, this will explode 
		img = mat.texture_slots[0].texture.image

		bm.faces[i][tex_layer].image = img

# copy the modified data into the mesh 
	bm.to_mesh(mesh)
########################################################################## 
def Create_Material(name):
	return bpy.data.materials.new(name)
########################################################################## 
def Exists_Material(ref):
	if is_string(ref):
		if ref in bpy.data.materials:
			return True
		else:
			return False
# redundant but for safety 
	else:
		if ref.name in bpy.data.materials:
			return True
		else:
			return False
########################################################################## 
def Delete_Material(name):
	matref = None
	if is_string(name):
		matref = Get_Material(name)
	else:
		matref = name
	bpy.data.materials.remove(matref)
########################################################################## 
def Get_Material(name):
	if name in bpy.data.materials:
		return bpy.data.materials[name]
########################################################################## 
def Get_Material_or_New(mat_name):
	materials = bpy.data.materials
# if .get returns None, the assignment comes from the right of the 'or' 
	mat = materials.get(mat_name) or materials.new(mat_name)
	return mat
########################################################################## 
def Material_Add_to_Object(ref, matname):
	objref = None
	matref = None
	if is_string(ref):
		objref = get_object(ref)
	else:
		objref = ref

	if is_string(matname):
		matref = Get_Material_or_New(matname)
	else:
		matref = matname

	if matref is not None:
		objref.data.materials.append(matref)
########################################################################## 
def Material_Remove_from_Object(ref, matname):
	objref = None
	if is_string(ref):
		objref = get_object(ref)
	else:
		objref = ref

	matindex = objref.data.materials.find(matname)
	if matname in objref.data.materials:
		objref.data.materials.pop(index=matindex)
########################################################################## 

########################################################################## 

########################################################################## 
def Get_Materials_from_Object(ref):
	objref = None
	if is_string(ref):
		objref = get_object(ref)
	else:
		objref = ref
	mat_list = []
	mats = objref.data.materials.items()
	for m in mats:
		mat_list.append(m[1])
	return mat_list
########################################################################## 
def Get_Material_Names_from_Object(ref):
	objref = None
	if is_string(ref):
		objref = get_object(ref)
	else:
		objref = ref
	name_list = []
	mats = objref.data.materials.items()
	for m in mats:
		name_list.append(m[0])
	return name_list
########################################################################## 
#endregion 
########################################################################## 
#region NODES 
########################################################################## 
def Mat_use_Nodes(matref, value):
	if value is True:
		matref.use_nodes = True
	else:
		matref.use_nodes = False
########################################################################## 
def Mat_get_Node_Tree(matref):
	matref.use_nodes = True
	return matref.node_tree.nodes
########################################################################## 
def Mat_Create_Node(nodes, nodetype):
	return nodes.new(type=nodetype)
########################################################################## 
def Mat_Get_Node_Links(matref):
	return matref.node_tree.links
########################################################################## 
def Mat_Create_Node_link(matref, np1, np2):
	links = matref.node_tree.links
	return links.new(np1,np2)
########################################################################## 
#endregion 
########################################################################## 
#region TEXTURES 
########################################################################## 
# 
def Tex_Create_Texture(name="Texture", type='CLOUDS'):
	if type is not None:
		return bpy.data.textures.new(name, type.upper())
########################################################################## 
def Tex_Get_Texture(name):
	res=""
	if name is not None:
		if name in bpy.data.textures:
			res=bpy.data.textures[name]
	return res
########################################################################## 
def Tex_Get_all_Texture():
	res=bpy.data.textures
	return res
########################################################################## 

########################################################################## 
def Tex_rename_Texture(ref, name):
	tex_ref = None
	if is_string(ref):
		tex_ref = Tex_Get_Texture(ref)
	else:
		tex_ref = ref
	if name is not None:
		tex_ref.name = name
########################################################################## 
def Tex_Delete_Texture(ref):
	if is_string(ref):
		bpy.data.textures.remove(Tex_Get_Texture(ref))
	else:
		bpy.data.textures.remove(ref)
########################################################################## 
#endregion 
########################################################################## 
#region MODIFIERS 
########################################################################## 
def Mod_add(obj, name, id):
	objref = None
	if is_string(obj):
		objref = get_object(obj)
	else:
		objref = obj
	new_mod = objref.modifiers.new(name, id)
	for area in bpy.context.screen.areas:
		if area.type == 'PROPERTIES':
			area.tag_redraw()
	return new_mod

def Mod_get(obj, name):
	objref = None
	if is_string(obj):
		objref = get_object(obj)
	else:
		objref = obj
	if name in objref.modifiers:
		return objref.modifiers[name]
	else:
		return False
########################################################################## 
def Mod_delete(ref, name):
	objref = None
	if is_string(ref):
		objref = get_object(ref)
	else:
		objref = ref

	if is_string(name):
		if name in objref.modifiers:
			mod = Mod_get(objref,name)
			objref.modifiers.remove(mod)
	else:
		objref.modifiers.remove(name)

	for area in bpy.context.screen.areas:
		if area.type == 'PROPERTIES':
			area.tag_redraw()
########################################################################## 
# Specific Modifiers 
########################################################################## 
def add_data_transfer(ref, modname = "DataTransfer"):
	return Mod_add(ref,modname,'DATA_TRANSFER')
########################################################################## 
def add_mesh_cache(ref, modname = "MeshCache"):
	return Mod_add(ref,modname,'MESH_CACHE')
########################################################################## 
def add_mesh_sequence_cache(ref, modname = "MeshSequenceCache"):
	return Mod_add(ref,modname,'MESH_SEQUENCE_CACHE')
########################################################################## 
def add_normal_edit(ref, modname = "NormalEdit"):
	return Mod_add(ref,modname,'NORMAL_EDIT')
########################################################################## 
def add_weighted_normal(ref, modname = "WeightedNormal"):
	return Mod_add(ref,modname,'WEIGHTED_NORMAL')
########################################################################## 
def add_uv_project(ref, modname = "UVProject"):
	return Mod_add(ref,modname,'UV_PROJECT')
########################################################################## 
def add_uv_warp(ref, modname = "Warp"):
	return Mod_add(ref,modname,'UV_WARP')
########################################################################## 
def add_vertex_weight_edit(ref, modname = "VertexWeightEdit"):
	return Mod_add(ref,modname,'VERTEX_WEIGHT_EDIT')
########################################################################## 
def add_vertex_weight_mix(ref, modname = "VertexWeightMix"):
	return Mod_add(ref,modname,'VERTEX_WEIGHT_MIX')
########################################################################## 
def add_vertex_weight_proximity(ref, modname = "VertexWeightProximity"):
	return Mod_add(ref,modname,'VERTEX_WEIGHT_PROXIMITY')
########################################################################## 
def add_array(ref, modname = "Array"):
	return Mod_add(ref,modname,'ARRAY')
########################################################################## 
def add_bevel(ref, modname = "Bevel"):
	return Mod_add(ref,modname,'BEVEL')
########################################################################## 
def add_boolean(ref, modname = "Boolean"):
	return Mod_add(ref,modname,'BOOLEAN')
########################################################################## 
def add_build(ref, modname = "Build"):
	return Mod_add(ref,modname,'BUILD')
########################################################################## 
def add_decimate(ref, modname = "Decimate"):
	return Mod_add(ref,modname,'DECIMATE')
########################################################################## 
def add_edge_split(ref, modname = "EdgeSplit"):
	return Mod_add(ref,modname,'EDGE_SPLIT')
########################################################################## 
def add_mask(ref, modname = "Mask"):
	return Mod_add(ref,modname,'MASK')
########################################################################## 
def add_mirror(ref, modname = "Mirror"):
	return Mod_add(ref,modname,'MIRROR')
########################################################################## 
def add_multires(ref, modname = "Multires"):
	return Mod_add(ref,modname,'MULTIRES')
########################################################################## 
def add_remesh(ref, modname = "Remesh"):
	return Mod_add(ref,modname,'REMESH')
########################################################################## 
def add_screw(ref, modname = "Screw"):
	return Mod_add(ref,modname,'SCREW')
########################################################################## 
def add_skin(ref, modname = "Skin"):
	return Mod_add(ref,modname,'SKIN')
########################################################################## 
def add_solidify(ref, modname = "Solidify"):
	return Mod_add(ref,modname,'SOLIDIFY')
########################################################################## 
def add_subsurf(ref, modname = "Subsurf"):
	return Mod_add(ref,modname,'SUBSURF')
########################################################################## 
def add_triangulate(ref, modname = "Triangulate"):
	return Mod_add(ref,modname,'TRIANGULATE')
########################################################################## 
def add_weld(ref, modname = "Weld"):
	return Mod_add(ref,modname,'WELD')
########################################################################## 
def add_wireframe(ref, modname = "Wireframe"):
	return Mod_add(ref,modname,'WIREFRAME')
########################################################################## 
def add_armature(ref, modname = "Armature"):
	return Mod_add(ref,modname,'ARMATURE')
########################################################################## 
def add_cast(ref, modname = "Cast"):
	return Mod_add(ref,modname,'CAST')
########################################################################## 
def add_curve(ref, modname = "Curve"):
	return Mod_add(ref,modname,'CURVE')
########################################################################## 
def add_displace(ref, modname = "Displace"):
	return Mod_add(ref,modname,'DISPLACE')
########################################################################## 
def add_hook(ref, modname = "Hook"):
	return Mod_add(ref,modname,'HOOK')
########################################################################## 
def add_laplacian_deform(ref, modname = "LaplacianDeform"):
	return Mod_add(ref,modname,'LAPLACIANDEFORM')
########################################################################## 
def add_lattice(ref, modname = "Lattice"):
	return Mod_add(ref,modname,'LATTICE')
########################################################################## 
def add_mesh_deform(ref, modname = "Deform"):
	return Mod_add(ref,modname,'MESH_DEFORM')
########################################################################## 
def add_shrinkwrap(ref, modname = "Shrinkwrap"):
	return Mod_add(ref,modname,'SHRINKWRAP')
########################################################################## 
def add_simple_deform(ref, modname = "SimpleDeform"):
	return Mod_add(ref,modname,'SIMPLE_DEFORM')
########################################################################## 
def add_smooth(ref, modname = "Smooth"):
	return Mod_add(ref,modname,'SMOOTH')
########################################################################## 
def add_corrective_smooth(ref, modname = "CorrectiveSmooth"):
	return Mod_add(ref,modname,'CORRECTIVE_SMOOTH')
########################################################################## 
def add_laplacian_smooth(ref, modname = "LaplacianSmooth"):
	return Mod_add(ref,modname,'LAPLACIANSMOOTH')
########################################################################## 
def add_surface_deform(ref, modname = "SurfaceDeform"):
	return Mod_add(ref,modname,'SURFACE_DEFORM')
########################################################################## 
def add_warp(ref, modname = "Warp"):
	return Mod_add(ref,modname,'WARP')
########################################################################## 
def add_wave(ref, modname = "Wave"):
	return Mod_add(ref,modname,'WAVE')
########################################################################## 
def add_cloth(ref, modname = "Cloth"):
	return Mod_add(ref,modname,'CLOTH')
########################################################################## 
def add_collision(ref, modname = "Collision"):
	return Mod_add(ref,modname,'COLLISION')
########################################################################## 
def add_dynamic_paint(ref, modname = "DynamicPaint"):
	return Mod_add(ref,modname,'DYNAMIC_PAINT')
########################################################################## 
def add_explode(ref, modname = "Explode"):
	return Mod_add(ref,modname,'EXPLODE')
########################################################################## 
def add_fluid(ref, modname = "Fluid"):
	return Mod_add(ref,modname,'FLUID')
########################################################################## 
def add_ocean(ref, modname = "Ocean"):
	return Mod_add(ref,modname,'OCEAN')
########################################################################## 
def add_particle_instance(ref, modname = "ParticleInstance"):
	return Mod_add(ref,modname,'PARTICLE_INSTANCE')
########################################################################## 
def add_particle_system(ref, modname = "ParticleSystem"):
	return Mod_add(ref,modname,'PARTICLE_SYSTEM')
########################################################################## 
def add_soft_body(ref, modname = "SoftBody"):
	return Mod_add(ref,modname,'SOFT_BODY')
########################################################################## 
def add_surface(ref, modname = ""):
	return Mod_add(ref,modname,'SURFACE')
########################################################################## 
def add_simulation(ref, modname = ""):
	return Mod_add(ref,modname,'SIMULATION')
########################################################################## 
#endregion 
########################################################################## 
#region TEXT OBJECTS 
########################################################################## 
def Text_Create(textname):
	return bpy.data.texts.new(textname)
########################################################################## 
def Text_Object_Delete(textname):
	if is_string(textname):
		t = bpy.data.texts[textname]
		bpy.data.texts.remove(t)
	else:
		bpy.data.texts.remove(textname)
########################################################################## 
def Text_Object_get_Lines(textname):
	return bpy.data.texts[textname].lines
########################################################################## 
#endregion 
########################################################################## 
#region DATA CHECKS 
########################################################################## 
def is_string(ref):
	if isinstance(ref, str):
		return True
	else:
		return False
########################################################################## 
#endregion 
########################################################################## 
#region DATA CONSTRUCTORS 
########################################################################## 
def Make_Vector(data):
	return Vector((data[0],data[1],data[2]))
########################################################################## 
#endregion 
########################################################################## 
#region MISC 
########################################################################## 
########################################################################## 
def Clear_unused_Data(a=1):
	if a==1:
		Remove_Collection("RigidBodyWorld")
	bpy.ops.outliner.orphans_purge()

########################################################################## 

########################################################################## 
#endregion 
########################################################################## 

########################################################################## 
# 
########################################################################## 
# Duplicate Real Object (untested) 
def Duplicate_Object_with_name(name='Cube',newname='Cube_001'):
	obj = bpy.data.objects.get(name)
	if obj:
# Create the new object by linking to the template's mesh data 
		oba = bpy.data.objects.new(newname,obj.data)
# Make it a real separate Object 
		oba.data = obj.data.copy()
# Create a new animation for the newly created object 
		animation = oba.animation_data_create()
# Option 1: Linking action 
#------------------------- 
#Assign the template object's action to the new animation 
#animation.action = template_object.animation_data.action 
# Option2: NOT Linking action 
#---------------------------- 
# Assign a copy of the template object's action to the new animation 
#		animation.action = obj.animation_data.action.copy() 
# Rename it if desired 
#		animation.action.name = 'NewAction' 

# Remove all Modifiers and Constraints on Copy 
		oba.modifiers.clear()
		oba.constraints.clear()

# Link the new object to the appropriate collection 
		bpy.context.scene.collection.objects.link(oba)
	return oba
########################################################################## 
# Doesnt work! 
def Duplicate_Object(obj,newname='Cube_001'):
	ret=Duplicate_Object_with_name(obj.name,newname)
	return ret
########################################################################## 
def MakeNewPlank(col,Plank,xpo,ypo,zpo,rox,lnk=0):
# Erzeuge Linked Plank von Original 
	obj=Make_Linked(Plank,lnk)
	MoveObjToCollection(col,obj)
	Setloc(obj,xpo,ypo,zpo)
	obj.rotation_mode = 'XYZ'
	obj.rotation_euler=(0,0,rox)
	return obj
########################################################################## 
# col - collection 
# Obj muss selektiert sein 
# dir: 0-X, 1-Y, 2-Z 
def Makeline(inp=3,dir=0,dist=1.01,lnk=0):
	if lnk==0:
		nam="Dups_"+str(dir)
	else:
		nam="RealObj"
	col=NewCollection(nam)

	olist=bpy.context.selected_objects
	tar=inp+1
	for num in range(1,tar):
		print("Lining Up "+str(dir)+":"+str(num)+"/"+str(tar)+" lnk:"+str(lnk))
		for oba in olist:
			a=Geo_Size_Vect(dir)
			b=a*dist*num
			obj=Make_Linked(oba,lnk)
			#Link_Obj_to_Scene(obj)
			MoveObjToCollection(col,obj)
			if dir==0:
				obj.location.x+=b
			elif dir==1:
				obj.location.y+=b
			else:
				obj.location.z+=b
########################################################################## 
# Obj muss selektiert sein 
def MakelineX(inp=3,dist=1.01,lnk=0):
	Makeline(inp,0,dist,lnk)
########################################################################## 
def MakelineY(inp=3,dist=1.01,lnk=0):
	Makeline(inp,1,dist,lnk)
########################################################################## 
def MakelineZ(inp=3,dist=1.01,lnk=0):
	Makeline(inp,2,dist,lnk)
########################################################################## 
def MakeQuadXY(num=3,dist=1.01,lnk=0):
	num-=1
	MakelineX(num,dist,lnk)
	MakelineY(num,dist,lnk)
########################################################################## 
def MakeQuadXZ(num=3,dist=1.01,lnk=0):
	num-=1
	MakelineX(num,dist,lnk)
	MakelineZ(num,dist,lnk)
########################################################################## 
def MakeQuadYZ(num=3,dist=1.01,lnk=0):
	num-=1
	MakelineY(num,dist,lnk)
	MakelineZ(num,dist,lnk)
########################################################################## 
def MakeCube(num=3,hi=3,lnk=0,dist=1.01):
	print("MakeCube Phase 1")
	MakeQuadXY(num,dist,lnk)
	hi-=1
	print("MakeCube Phase 2")
	MakelineZ(hi,dist,lnk)

########################################################################## 
# col - Collection where to insert the Layer 
# Plank - link to Object that will be duplicated for the Planks 
# si - No of Plank per Line 
# cor - corners, Number of corners (Steps) can be 4 or 8 
# x,y,z - Coordinates where the Tower is placed 
def MakeQuad(col,Plank,si,cor,x,y,z,lnk=0):
	phi=.9
	pi=3.1415926
	pi2=2*pi
	con=180/pi
	step=pi2/cor
	wi=(360/cor)/con
	i=0
	ro=0
	target=pi2-.1
	while (i<target):
		if z & 1:
			rox=43
			row=1
		else:
			rox=0
			row=0
		xp=sin(i+rox)*si+x
		yp=cos(i+rox)*si+y
		zp=z*(2*phi)-phi
		MakeNewPlank(col,Plank,xp,yp,zp,ro+row,lnk=0)
#print ("Plank at",xp,yp,"with:",ro) 
		ro+=wi
		i+=step

###################################################################### 
# 
# 
###################################################################### 
def Make_Cube(number=5,size=1,dist=0.25,x=0,y=0,z=0,pow=250,ac=0,rest=0.95):
	if z==0:
		z=size*1.1
	AddArray(0,number,dist)
	bpy.ops.object.apply_all_modifiers()
	AddArray(1,number,dist)
	bpy.ops.object.apply_all_modifiers()
	AddArray(2,number,dist)
	bpy.ops.object.apply_all_modifiers()
	bpy.ops.object.mode_set(mode='EDIT')
	bpy.ops.mesh.separate(type='LOOSE')
	bpy.ops.object.mode_set(mode='OBJECT')
	bpy.ops.object.origin_set(type='ORIGIN_GEOMETRY', center='MEDIAN')
#bpy.ops.object.origin_set(type='ORIGIN_CENTER_OF_MASS', center='MEDIAN') 


########################################################################## 
# CubeSize 
# 
########################################################################## 
def PlaceInCube(CubeSize=10):
	d=(CubeSize/2)          # size of area where the balls spawn (STRG+Q to see what I mean)
	xpos=0
	zpos=0
	ypos=3
	for newBall in bpy.context.selected_objects:
		xpos=r.uniform(0,d)
		xpos=xpos*2-d
		ypos=r.uniform(0,d)
		ypos=ypos*2-d
		zpos=r.uniform(0,d)
		zpos=zpos*2-d
#print('Moving Object') 
		newBall.rotation_euler = (0, 0, 0)
		newBall.location = (xpos, ypos, zpos)


########################################################################## 
# Tower_high, how many "floors" the tower shall have (the more floors the higher the Baking Precision must be set) 
# cor - Corners, can be 4 or 8 (you can choose others but this will not bne stable) 
# x,y,z - Coordinates where the Tower shall be built 
########################################################################## 

def MakeQuadTower(Tower_high=80,cor=8,x=0,y=0,z=0,lnk=0):
#Time before the operations start 
	then = time.time()
# Add Cube with size .8 
	Plank_Len=12
	siz=.8
	hg=0.9
	AddCube(0,0,0,1)
#---------------------------------------------------------------- 
	obj=bpy.context.selected_objects[0]
	cube2plank(obj,siz,Plank_Len)
#---------------------------------------------------------------- 
# ReCenter Obj Geometry 
	myobj=ReCenterGeo(obj,hg)
#AssignNewMaterial(myobj) 
	col=NewCollection("Quad")
	LinkToCollection(col,obj)

	si=Plank_Len+(siz*2.6)
	for i in range(1,Tower_high):
		print("Construction ongoing:"+str(i))
		MakeQuad(col,myobj,si,cor,x,y,i,lnk)
	now = time.time() #Time after it finished
	print("Built Quad-Tower in: ", now-then, " seconds.")
########################################################################## 
# col - collection where to insert the Planks 
# Plank - object/Plank that is duplicated 
# ap - number of Planks in a floor /4 
# xof,yof - offset for x and y (z is below) 
# y - this is the z-Position 
# Creates the Planks that are 90 Degree rotated 
def MakeCircle_S(col,Plank,ap,xof,yof,y,lnk=0):
	pi=3.14159267
	pi2=2*pi
	tar=pi2-.001
	sz=.8
# phi = Plankenhöhe (0.9) 
	phi=.9
# Plank-Length 
	Plank_Len=6
	ps=6
# Schleifen Variable für Kreis des Turmes 
	i=0
	sg=1-sz

# Anzahl der Planks in einer Ebene z.b. 12 
	Anz_Planks=ap*4

# Schleifen-Increment pro Durchlauf 
	inc=pi2/Anz_Planks

# Rotations-Increment damit Planks in Kreisform sind 
	ai=360/Anz_Planks
# Das ist bei einer Plank-Lenght von 6 eben 60-3 also eigentlich Länge+10 Minus 10% damit die Planken sich nicht berühren 
	roi=-ai/((ps*10.05)-(ps/2))

# Größenfaktor für Kreis 
	s=Anz_Planks*pi*.65 # 2.132

	s=(s/100*(49/2))

	ro=0
	cnt=0

# Schleife die den Kreis aus Planks erstellt 
	while i<tar:
#-------------------------------------------------------------- 
# Loop increment 
		i+=inc
		cnt+=1
#-------------------------------------------------------------- 
# Setze Location der Plank 
		dx = sin(i)*s+xof
		dy = cos(i)*s+yof
		dz = y*(2*phi)-phi
#-------------------------------------------------------------- 
# Rotiere die Plank 
		ro+=roi
		rox=ro+29.8

#-------------------------------------------------------------- 
# Erzeuge Linked Plank von Original bei xpo,ypo,zpo und Rotiere um rox 
		obj=MakeNewPlank(col,Plank,dx,dy,dz,rox,lnk=0)
###################################################################### 
# col - collection where to insert the Planks 
# Plank - object/Plank that is duplicated 
# ap - number of Planks in a floor /4 
# xof,yof - offset for x and y (z is below) 
# y - this is the z-Position 
# sig - signal that will influence the Circel-Size in a way taht it all fits together 
# Planks that are not rotated (follow along circle) 
def MakeCircle_L(col,Plank,ap,xof,yof,y,sig,lnk=0):
	pi=3.1415926
	pi2=2*pi
	tar=pi2-.001
	sz=0.8
# phi = Plankenhöhe (0.9) 
	phi=0.9
# Plank-Length 
	Plank_Len=6
	ps=6
# Schleifen Variable für Kreis des Turmes 
	i=0
	sg=1-sz

# Anzahl der Planks in einer Ebene z.b. 12 
	Anz_Planks=ap

	ma=Anz_Planks+1
# Schleifen-Increment pro Durchlauf 
	inc=pi2/Anz_Planks

# Rotations-Increment damit Planks in Kreisform sind 
	ai=360/Anz_Planks
# Das ist bei einer Plank-Lenght von 6 eben 60-3 also eigentlich Länge+10 Minus 10% damit die Planken sich nicht berühren 
	roi=-ai/((ps*10.05)-(ps/2))

# Größenfaktor für Kreis sif=.335-> Mitte 
	saf=(1/Anz_Planks)*.25
	if sig==1:
		sif=.334-saf
	else:
		sif=.337+saf

	s=Anz_Planks*pi2*sif

	ro=0
	cnt=0

# Schleife die den Kreis aus Planks erstellt 
	while i<tar:
#-------------------------------------------------------------- 
# Loop increment 
		i+=inc
		cnt+=1
#-------------------------------------------------------------- 
# Setze Location der Plank 
		dx = sin(i)*s+xof
		dy = cos(i)*s+yof
		dz = y*(2*phi)-phi

#-------------------------------------------------------------- 
# Rotiere die Plank 
		ro+=roi
		rox=ro+.3

#-------------------------------------------------------------- 
# Erzeuge Linked Plank von Original bei xpo,ypo,zpo und Rotiere um rox 
		obj=MakeNewPlank(col,Plank,dx,dy,dz,rox,lnk=0)

########################################################################## 
# Will return the highest Planks Position 
# x,y - Position of the Tower 
# size - number of Planks for the Circle of the Tower 
# hi - How High the Tower is (in floors, each Floor is 1 plank high) 
def Roundtower(x,y,size,hi,lnk=0):
	then = time.time() #Time before the operations start
# sz - Breite,12 -Anzahl Planks,xoffset,yoffset,Höhe 
	Plank_Len=6
# Add Cube with size .8 
	siz=.8
	hg=0.9
	AddCube(0,0,0,1)
#---------------------------------------------------------------- 
	obj=bpy.context.selected_objects[0]
	cube2plank(obj,siz,Plank_Len)
#---------------------------------------------------------------- 
# ReCenter Obj Geometry 
	myobj=ReCenterGeo(obj,hg)
	Setloc(myobj,0,0,-10)
#AssignNewMaterial(myobj) 
	col=NewCollection("Tower")
	LinkToCollection(col,obj)

	for za in range(1,hi):
		print("Building Level: "+str(za))
#ypos=m.cos(za)+y 
		ypos=y
# xpos=m.sin(za)+x 
		xpos=x
		SizeA=size
		SizeB=size-(size/100*5)
		if za & 1:
			MakeCircle_S(col,myobj,SizeA,xpos,ypos,za,lnk)
		else:
			MakeCircle_L(col,myobj,SizeB,xpos,ypos,za,1,lnk)
			MakeCircle_L(col,myobj,SizeB,xpos,ypos,za,0,lnk)

	now = time.time() #Time after it finished
	print("It took: ", now-then, " seconds")
	return za

########################################################################## 
def RB_MakeSceneA():
	import bpy
	bpy.ops.mesh.primitive_plane_add(size=440, location=(0, 0, 0)) # create Plane
	bpy.ops.rigidbody.object_add()
	bpy.context.object.rigid_body.type = 'PASSIVE'
	for x in range(1,19): # create Toruses
		bpy.ops.mesh.primitive_torus_add(location=(0, x*4.3, 110), rotation=(0,1.5708*(x%2), 0), major_radius=3.5, minor_radius=.5, abso_major_rad=1.25, abso_minor_rad=0.75)
		bpy.ops.rigidbody.object_add()
		bpy.context.object.rigid_body.collision_shape = 'MESH'
		print("Generating Chains:"+str(x)+"/19")
		if x==1:
			bpy.context.object.rigid_body.enabled = False
		for z in range (0,9): # create Cubes
			print("Generating Cubes:"+str(z)+"/9")
			for m in range (0,9): # create Cubes
				bpy.ops.mesh.primitive_cube_add(size=5.9, location=(x*6-60,2+m*6,2.8+z*6))
				bpy.ops.rigidbody.object_add()
				bpy.context.object.rigid_body.mass = 0.0001

#bpy.ops.mesh.primitive_torus_add(location=(x*2, x*4.3, 110), rotation=(0,1.5708*(x%2), 0), major_radius=3.5+1*(x==18), minor_radius=.5+1*(x==18), abso_major_rad=1.25, abso_minor_rad=0.75) 
########################################################################## 

def RB_MakeSceneB(lnk=0):
# Delete all object, do leave collections empty. 
#DeleteAll() 
	print("This may take a while. Please be patient.")
#---------------------------------------------------------------- 
# Add Plane 
	AddPlane(10,10,0,2580)
#---------------------------------------------------------------- 
	for i in range(1,10):
		print("Starting up:"+str(i)+"/10")
		pow=.013+((10-i)*.02)
########################################################################## 
# number ... 12 
# size ... 1 
# dist ... 0.75 (must be < size to explode) 
# typ - '1 - Sphere, 0 - Menger, 2- Cube, 3 - Rock 
# optional parameters: 
# x,y,z - where to place the Object 
# pow -> 0.01 bis 10000 - Weight of objects (Power to destroy) 
# ac - 0/1 - 1-> start deactivated 0 - not deactivated 
# rest - Set Bouncing Factor for Rigib Body 0 ... 1 (please set Floor to same) 
		if i==2:
			dea=0
		else:
			dea=1
########################################################################## 
# number ... 12 
# size ... 1 
# dist ... 0.75 (must be < size to explode) 
# typ - '1 - Sphere, 0 - Menger, 2- Cube, 3 - Rock 
# optional parameters: 
# x,y,z - where to place the Object 
# pow -> 0.01 bis 10000 - Weight of objects (Power to destroy) 
# ac - 0/1 - 1-> start deactivated 0 - not deactivated 
# rest - Set Bouncing Factor for Rigib Body 0 ... 1 (please set Floor to same) 
#	Do_Axis(5,1,0.25,2,110,110,i*30,pow,dea,0.98) 
#---------------------------------------------------------------- 
	Hi=40
# Offset for City 
	x=0
	y=0

# Size of City 2 ... 12 ..? 
	szi=10

	for j in range(1,szi):
		for i in range(1,szi):
			h=r.randint(80,160)
			t=r.randint(0,2)
			if t>1:
				k=4
			else:
				k=8
########################################################################## 
# Tower_high, how many "floors" the tower shall have (the more floors the higher the Baking Precision must be set) 
# cor - Corners, can be 4 or 8 (you can choose others but this will not bne stable) 
# x,y,z - Coordinates where the Tower shall be built 
			print("Building Towers:"+str(j)+"/"+str(szi))
			MakeQuadTower(h+x,k+y,i*80,j*80,0,lnk)

# BAKE 
	RB_Bake(240,240)






